/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.gitlfs.internal;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.joda.time.DateTime;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.gitlfs.internal.GitLfsBatchRequest;
import org.sonatype.nexus.repository.gitlfs.internal.GitLfsBatchRequestParser;
import org.sonatype.nexus.repository.gitlfs.internal.GitLfsCoordinate;
import org.sonatype.nexus.repository.gitlfs.internal.GitLfsHostedFacet;
import org.sonatype.nexus.repository.gitlfs.internal.GitLfsJsonUtils;
import org.sonatype.nexus.repository.gitlfs.internal.GitLfsOperation;
import org.sonatype.nexus.repository.gitlfs.internal.GitLfsRequestException;
import org.sonatype.nexus.repository.gitlfs.internal.GitLfsTransfer;
import org.sonatype.nexus.repository.http.HttpResponses;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.view.Context;
import org.sonatype.nexus.repository.view.Handler;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.Response;
import org.sonatype.nexus.repository.view.Status;
import org.sonatype.nexus.repository.view.payloads.StringPayload;

@Named
@Singleton
public class GitLfsHostedBatchEndpointHandler
extends ComponentSupport
implements Handler {
    private static final int EXPIRY_MINUTES = 15;
    private final ObjectMapper mapper = new ObjectMapper();
    private final GitLfsBatchRequestParser batchRequestParser;

    @Inject
    public GitLfsHostedBatchEndpointHandler(GitLfsBatchRequestParser batchRequestParser) {
        this.batchRequestParser = (GitLfsBatchRequestParser)((Object)Preconditions.checkNotNull((Object)((Object)batchRequestParser)));
    }

    @Nonnull
    public Response handle(@Nonnull Context context) throws Exception {
        GitLfsBatchRequest request;
        Preconditions.checkNotNull((Object)context);
        if (!"POST".equals(context.getRequest().getAction())) {
            return new Response.Builder().status(Status.failure((int)405, null)).payload((Payload)new StringPayload(this.mapper.writeValueAsString(GitLfsJsonUtils.buildBatchResponse("Not Allowed")), "application/vnd.git-lfs+json")).build();
        }
        Repository repository = context.getRepository();
        Payload payload = (Payload)Preconditions.checkNotNull((Object)context.getRequest().getPayload());
        Throwable throwable = null;
        Object var6_6 = null;
        try (InputStream is = payload.openInputStream();){
            request = this.batchRequestParser.parse(is);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        if (!GitLfsOperation.UPLOAD.equals(request.getOperation()) && !GitLfsOperation.DOWNLOAD.equals(request.getOperation())) {
            throw new GitLfsRequestException(String.format("Only 'upload' and 'download' operations are supported (was %s)", request.getOperation()));
        }
        if (!request.getTransfers().contains(GitLfsTransfer.BASIC)) {
            throw new GitLfsRequestException(String.format("Only the 'basic' transfer adapter is supported (was %s)", request.getTransfers()));
        }
        Map<String, String> headers = GitLfsJsonUtils.buildAuthorizationHeaders(context.getRequest().getHeaders());
        List<Map<String, Object>> responseObjects = this.buildResponse(repository, request, headers);
        return HttpResponses.ok((Payload)new StringPayload(this.mapper.writeValueAsString(GitLfsJsonUtils.buildBatchResponse(GitLfsTransfer.BASIC, responseObjects)), "application/vnd.git-lfs+json"));
    }

    private List<Map<String, Object>> buildResponse(Repository repository, GitLfsBatchRequest request, Map<String, String> headers) {
        GitLfsOperation operation = request.getOperation();
        return request.getObjects().stream().map(coordinate -> GitLfsJsonUtils.buildObjectResponse(coordinate, this.buildObjectContents(repository, operation, (GitLfsCoordinate)coordinate, headers))).collect(Collectors.toList());
    }

    private Map<String, Object> buildObjectContents(Repository repository, GitLfsOperation operation, GitLfsCoordinate coordinate, Map<String, String> headers) {
        Preconditions.checkNotNull((Object)repository);
        Preconditions.checkNotNull((Object)operation);
        Preconditions.checkNotNull((Object)coordinate);
        Preconditions.checkNotNull(headers);
        GitLfsHostedFacet hostedFacet = (GitLfsHostedFacet)repository.facet(GitLfsHostedFacet.class);
        Asset asset = hostedFacet.getAsset(coordinate.getOid());
        if (GitLfsOperation.UPLOAD.equals(operation)) {
            return this.buildObjectForUpload(repository, coordinate, headers, asset);
        }
        if (GitLfsOperation.DOWNLOAD.equals(operation)) {
            return this.buildObjectForDownload(repository, coordinate, headers, asset);
        }
        throw new IllegalStateException("Unexpected operation: " + operation);
    }

    private Map<String, Object> buildObjectForUpload(Repository repository, GitLfsCoordinate coordinate, Map<String, String> headers, @Nullable Asset asset) {
        Preconditions.checkNotNull((Object)repository);
        Preconditions.checkNotNull((Object)coordinate);
        Preconditions.checkNotNull(headers);
        if (asset == null) {
            return GitLfsJsonUtils.buildObjectUploadActions(repository.getUrl(), coordinate, headers, this.buildExpiresAtTimestamp());
        }
        return Collections.emptyMap();
    }

    private Map<String, Object> buildObjectForDownload(Repository repository, GitLfsCoordinate coordinate, Map<String, String> headers, @Nullable Asset asset) {
        Preconditions.checkNotNull((Object)repository);
        Preconditions.checkNotNull((Object)coordinate);
        Preconditions.checkNotNull(headers);
        if (asset == null) {
            return GitLfsJsonUtils.buildObjectDownloadNotFoundError();
        }
        if (!Objects.equals(coordinate.getSize(), asset.size())) {
            return GitLfsJsonUtils.buildObjectDownloadSizeMismatchError(coordinate);
        }
        return GitLfsJsonUtils.buildObjectDownloadActions(repository.getUrl(), coordinate, headers, this.buildExpiresAtTimestamp());
    }

    private DateTime buildExpiresAtTimestamp() {
        return DateTime.now().plusMinutes(15);
    }
}

