/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.gitlfs.internal;

import javax.annotation.Nonnull;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.gitlfs.internal.GitLfsHostedFacet;
import org.sonatype.nexus.repository.http.HttpResponses;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.repository.view.Context;
import org.sonatype.nexus.repository.view.Handler;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.Response;
import org.sonatype.nexus.repository.view.matchers.token.TokenMatcher;

@Named
@Singleton
public class GitLfsHostedDownloadHandler
extends ComponentSupport
implements Handler {
    @Nonnull
    public Response handle(@Nonnull Context context) throws Exception {
        TokenMatcher.State state = (TokenMatcher.State)context.getAttributes().require(TokenMatcher.State.class);
        String oid = (String)state.getTokens().get("oid");
        Repository repository = context.getRepository();
        GitLfsHostedFacet hostedFacet = (GitLfsHostedFacet)repository.facet(GitLfsHostedFacet.class);
        Content content = hostedFacet.getContent(oid);
        if (content == null) {
            return HttpResponses.notFound();
        }
        return HttpResponses.ok((Payload)content);
    }
}

