/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.gitlfs.internal;

import java.io.IOException;
import javax.annotation.Nullable;
import javax.inject.Named;
import org.sonatype.nexus.blobstore.api.Blob;
import org.sonatype.nexus.common.collect.AttributesMap;
import org.sonatype.nexus.repository.FacetSupport;
import org.sonatype.nexus.repository.config.Configuration;
import org.sonatype.nexus.repository.gitlfs.internal.GitLfsAttributes;
import org.sonatype.nexus.repository.gitlfs.internal.GitLfsHostedFacet;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.storage.AssetBlob;
import org.sonatype.nexus.repository.storage.Bucket;
import org.sonatype.nexus.repository.storage.Component;
import org.sonatype.nexus.repository.storage.StorageFacet;
import org.sonatype.nexus.repository.storage.StorageTx;
import org.sonatype.nexus.repository.storage.TempBlob;
import org.sonatype.nexus.repository.transaction.TransactionalStoreBlob;
import org.sonatype.nexus.repository.transaction.TransactionalStoreMetadata;
import org.sonatype.nexus.repository.transaction.TransactionalTouchBlob;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.payloads.BlobPayload;
import org.sonatype.nexus.transaction.Transactional;
import org.sonatype.nexus.transaction.UnitOfWork;

@Named
public class GitLfsHostedFacetImpl
extends FacetSupport
implements GitLfsHostedFacet {
    protected void doValidate(Configuration configuration) throws Exception {
        super.doValidate(configuration);
    }

    @Override
    @Nullable
    @Transactional
    public Asset getAsset(String path) {
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        return tx.findAssetWithProperty("name", (Object)path, tx.findBucket(this.getRepository()));
    }

    @Override
    @Nullable
    @TransactionalTouchBlob
    public Content getContent(String path) {
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Asset asset = tx.findAssetWithProperty("name", (Object)path, tx.findBucket(this.getRepository()));
        if (asset == null) {
            return null;
        }
        if (asset.markAsDownloaded()) {
            tx.saveAsset(asset);
        }
        Blob blob = tx.requireBlob(asset.requireBlobRef());
        return this.toContent(asset, blob);
    }

    @Override
    public Content put(String path, Payload content) throws IOException {
        StorageFacet storageFacet = (StorageFacet)this.facet(StorageFacet.class);
        Throwable throwable = null;
        Object var5_6 = null;
        try (TempBlob tempBlob = storageFacet.createTempBlob(content, GitLfsAttributes.HASH_ALGORITHMS);){
            return this.doPutContent(path, tempBlob, content);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @TransactionalStoreBlob
    protected Content doPutContent(String path, TempBlob tempBlob, Payload payload) throws IOException {
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Asset asset = this.getOrCreateAsset(path);
        AttributesMap contentAttributes = null;
        if (payload instanceof Content) {
            contentAttributes = ((Content)payload).getAttributes();
        }
        Content.applyToAsset((Asset)asset, (AttributesMap)Content.maintainLastModified((Asset)asset, (AttributesMap)contentAttributes));
        AssetBlob assetBlob = tx.setBlob(asset, path, tempBlob, null, payload.getContentType(), false);
        tx.saveAsset(asset);
        return this.toContent(asset, assetBlob.getBlob());
    }

    @TransactionalStoreMetadata
    protected Asset getOrCreateAsset(String path) {
        Asset asset;
        Bucket bucket;
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Component component = tx.findComponentWithProperty("name", (Object)path, bucket = tx.findBucket(this.getRepository()));
        if (component == null) {
            component = (Component)tx.createComponent(bucket, this.getRepository().getFormat()).group("").name(path);
            tx.saveComponent(component);
            asset = tx.createAsset(bucket, component);
            asset.name(path);
        } else {
            asset = tx.firstAsset(component);
            if (asset == null) {
                asset = tx.createAsset(bucket, component);
                asset.name(path);
            }
        }
        asset.markAsDownloaded();
        return asset;
    }

    private Content toContent(Asset asset, Blob blob) {
        Content content = new Content((Payload)new BlobPayload(blob, asset.requireContentType()));
        Content.extractFromAsset((Asset)asset, GitLfsAttributes.HASH_ALGORITHMS, (AttributesMap)content.getAttributes());
        return content;
    }
}

