/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.gitlfs.internal;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import java.io.InputStream;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.gitlfs.internal.GitLfsCoordinate;
import org.sonatype.nexus.repository.gitlfs.internal.GitLfsHostedFacet;
import org.sonatype.nexus.repository.gitlfs.internal.GitLfsJsonUtils;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.view.Context;
import org.sonatype.nexus.repository.view.Handler;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.Response;
import org.sonatype.nexus.repository.view.Status;
import org.sonatype.nexus.repository.view.matchers.token.TokenMatcher;
import org.sonatype.nexus.repository.view.payloads.StringPayload;

@Named
@Singleton
public class GitLfsHostedVerifyHandler
extends ComponentSupport
implements Handler {
    private final ObjectMapper mapper = new ObjectMapper();

    @Nonnull
    public Response handle(@Nonnull Context context) throws Exception {
        GitLfsCoordinate coordinate;
        Payload payload = (Payload)Preconditions.checkNotNull((Object)context.getRequest().getPayload());
        TokenMatcher.State state = (TokenMatcher.State)context.getAttributes().require(TokenMatcher.State.class);
        String oid = (String)state.getTokens().get("oid");
        Throwable throwable = null;
        Object var7_7 = null;
        try (InputStream in = payload.openInputStream();){
            coordinate = (GitLfsCoordinate)this.mapper.readValue(in, GitLfsCoordinate.class);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        Repository repository = context.getRepository();
        GitLfsHostedFacet hostedFacet = (GitLfsHostedFacet)repository.facet(GitLfsHostedFacet.class);
        Asset asset = hostedFacet.getAsset(oid);
        Optional<String> verificationMessage = this.verify(asset, coordinate);
        if (verificationMessage.isPresent()) {
            return this.buildResponse(Status.failure((int)500, null), GitLfsJsonUtils.buildBatchResponse(verificationMessage.get()));
        }
        return this.buildResponse(Status.success((int)200, null), GitLfsJsonUtils.buildObjectResponse(coordinate, Collections.emptyMap()));
    }

    private Optional<String> verify(Asset asset, GitLfsCoordinate coordinate) {
        if (asset == null) {
            return Optional.of("Object does not exist");
        }
        if (!Objects.equals(asset.size(), coordinate.getSize())) {
            return Optional.of("Sizes do not match");
        }
        if (!Objects.equals(asset.name(), coordinate.getOid())) {
            return Optional.of("OIDs do not match");
        }
        return Optional.empty();
    }

    private Response buildResponse(Status status, Map<String, Object> content) throws JsonProcessingException {
        return new Response.Builder().status(status).payload((Payload)new StringPayload(this.mapper.writeValueAsString(content), "application/vnd.git-lfs+json")).build();
    }
}

