/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.gitlfs.internal;

import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;
import org.sonatype.nexus.repository.gitlfs.internal.GitLfsCoordinate;
import org.sonatype.nexus.repository.gitlfs.internal.GitLfsLinkUtils;
import org.sonatype.nexus.repository.gitlfs.internal.GitLfsTransfer;
import org.sonatype.nexus.repository.view.Headers;

public final class GitLfsJsonUtils {
    private static final String OBJECTS = "objects";
    private static final String MESSAGE = "message";
    private static final String OID = "oid";
    private static final String SIZE = "size";
    private static final String HREF = "href";
    private static final String HEADER = "header";
    private static final String UPLOAD = "upload";
    private static final String VERIFY = "verify";
    private static final String DOWNLOAD = "download";
    private static final String ACTIONS = "actions";
    private static final String CODE = "code";
    private static final String ERROR = "error";
    private static final String TRANSFER = "transfer";
    private static final String EXPIRES_AT = "expires_at";
    private static final String AUTHENTICATED = "authenticated";
    private static final DateTimeFormatter EXPIRES_AT_FORMAT = ISODateTimeFormat.dateTimeNoMillis().withZone(DateTimeZone.UTC);

    public static Map<String, Object> buildBatchResponse(GitLfsTransfer transfer, List<Map<String, Object>> objects) {
        Preconditions.checkNotNull((Object)transfer);
        Preconditions.checkNotNull(objects);
        LinkedHashMap<String, Object> response = new LinkedHashMap<String, Object>();
        response.put(TRANSFER, transfer.getName());
        response.put(OBJECTS, objects);
        return response;
    }

    public static Map<String, Object> buildBatchResponse(String message) {
        return Collections.singletonMap(MESSAGE, Preconditions.checkNotNull((Object)message));
    }

    public static Map<String, Object> buildObjectResponse(GitLfsCoordinate coordinate, Map<String, Object> contents) {
        Preconditions.checkNotNull((Object)coordinate);
        Preconditions.checkNotNull(contents);
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        result.put(OID, coordinate.getOid());
        result.put(SIZE, coordinate.getSize());
        result.putAll(contents);
        return result;
    }

    public static Map<String, Object> buildObjectUploadActions(String repositoryUrl, GitLfsCoordinate coordinate, Map<String, String> headers, DateTime expiresAt) {
        Preconditions.checkNotNull((Object)repositoryUrl);
        Preconditions.checkNotNull((Object)coordinate);
        Preconditions.checkNotNull(headers);
        Preconditions.checkNotNull((Object)expiresAt);
        LinkedHashMap<String, Object> actions = new LinkedHashMap<String, Object>();
        actions.put(UPLOAD, GitLfsJsonUtils.buildObjectLink(GitLfsLinkUtils.buildUploadLink(repositoryUrl, coordinate), headers, expiresAt));
        actions.put(VERIFY, GitLfsJsonUtils.buildObjectLink(GitLfsLinkUtils.buildVerifyLink(repositoryUrl, coordinate), headers, expiresAt));
        return GitLfsJsonUtils.buildObjectActions(actions);
    }

    public static Map<String, Object> buildObjectDownloadActions(String repositoryUrl, GitLfsCoordinate coordinate, Map<String, String> headers, DateTime expiresAt) {
        Preconditions.checkNotNull((Object)repositoryUrl);
        Preconditions.checkNotNull((Object)coordinate);
        Preconditions.checkNotNull(headers);
        Preconditions.checkNotNull((Object)expiresAt);
        LinkedHashMap<String, Object> actions = new LinkedHashMap<String, Object>();
        actions.put(DOWNLOAD, GitLfsJsonUtils.buildObjectLink(GitLfsLinkUtils.buildDownloadLink(repositoryUrl, coordinate), headers, expiresAt));
        return GitLfsJsonUtils.buildObjectActions(actions);
    }

    private static Map<String, Object> buildObjectActions(Map<String, Object> actions) {
        LinkedHashMap<String, Object> results = new LinkedHashMap<String, Object>();
        results.put(AUTHENTICATED, true);
        results.put(ACTIONS, actions);
        return results;
    }

    private static Map<String, Object> buildObjectLink(String href, Map<String, String> header, DateTime expiresAt) {
        Preconditions.checkNotNull((Object)href);
        Preconditions.checkNotNull(header);
        Preconditions.checkNotNull((Object)expiresAt);
        LinkedHashMap<String, Object> link = new LinkedHashMap<String, Object>();
        link.put(HREF, href);
        link.put(HEADER, header);
        link.put(EXPIRES_AT, EXPIRES_AT_FORMAT.print((ReadableInstant)expiresAt));
        return link;
    }

    public static Map<String, Object> buildObjectDownloadNotFoundError() {
        return GitLfsJsonUtils.buildDownloadObjectError(404, "Object does not exist on the server");
    }

    public static Map<String, Object> buildObjectDownloadSizeMismatchError(GitLfsCoordinate coordinate) {
        Preconditions.checkNotNull((Object)coordinate);
        return GitLfsJsonUtils.buildDownloadObjectError(422, String.format("Object %s is not %s bytes", coordinate.getOid(), coordinate.getSize()));
    }

    private static Map<String, Object> buildDownloadObjectError(int code, String message) {
        Preconditions.checkNotNull((Object)message);
        LinkedHashMap<String, Object> error = new LinkedHashMap<String, Object>();
        error.put(CODE, code);
        error.put(MESSAGE, message);
        return Collections.singletonMap(ERROR, error);
    }

    public static Map<String, String> buildAuthorizationHeaders(Headers requestHeaders) {
        Preconditions.checkNotNull((Object)requestHeaders);
        LinkedHashMap<String, String> headers = new LinkedHashMap<String, String>();
        if (requestHeaders.contains("Authorization")) {
            headers.put("Authorization", requestHeaders.get("Authorization"));
        }
        return headers;
    }

    private GitLfsJsonUtils() {
    }
}

