/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.integration.rest.service;

import com.atlassian.crowd.exception.ApplicationPermissionException;
import com.atlassian.crowd.exception.InvalidAuthenticationException;
import com.atlassian.crowd.exception.InvalidCrowdServiceException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.integration.rest.entity.ErrorEntity;
import com.atlassian.crowd.integration.rest.service.CrowdRestException;
import com.atlassian.crowd.service.client.ClientProperties;
import com.google.common.base.Preconditions;
import com.sonatype.nexus.crowd.internal.CrowdClientProperties;
import com.sonatype.nexus.crowd.internal.Hc4Client;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.WeakHashMap;
import javax.inject.Inject;
import javax.xml.bind.DataBindingException;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;

public class RestExecutor {
    private static final String INVALID_REST_SERVICE_MSG_FORMAT = "The following URL does not specify a valid Crowd User Management REST service: %s";
    public static final String EMBEDDED_CROWD_VERSION_NAME = "X-Embedded-Crowd-Version";
    private static final Logger log = LoggerFactory.getLogger(RestExecutor.class);
    private static final Map<Class, JAXBContext> jaxbContexts = new WeakHashMap<Class, JAXBContext>();
    private final String baseUrl;
    private final String applicationName;
    private final String applicationPassword;
    private static Hc4Client hc4Client;
    private final Integer httpTimeout;
    private final boolean useTrustStore;

    RestExecutor(ClientProperties clientProperties) {
        try {
            new URI(clientProperties.getBaseURL());
            this.baseUrl = RestExecutor.createBaseUrl(clientProperties.getBaseURL());
            this.applicationName = clientProperties.getApplicationName();
            this.applicationPassword = clientProperties.getApplicationPassword();
            Integer n = this.httpTimeout = clientProperties.getHttpTimeout() == null ? null : Integer.valueOf(clientProperties.getHttpTimeout());
            this.useTrustStore = clientProperties instanceof CrowdClientProperties ? ((CrowdClientProperties)clientProperties).getUseTrustStore() : false;
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private static String createBaseUrl(String url) {
        StringBuilder sb = new StringBuilder(url);
        if (url.endsWith("/")) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("/rest/usermanagement/1");
        return sb.toString();
    }

    @Inject
    public static void setHc4Client(Hc4Client hc4Client) {
        RestExecutor.hc4Client = (Hc4Client)((Object)Preconditions.checkNotNull((Object)((Object)hc4Client)));
    }

    MethodExecutor get(String format, Object ... args) {
        return new MethodExecutor((HttpUriRequest)new HttpGet(RestExecutor.buildUrl(this.baseUrl, format, args)));
    }

    MethodExecutor delete(String format, Object ... args) {
        return new MethodExecutor((HttpUriRequest)new HttpDelete(RestExecutor.buildUrl(this.baseUrl, format, args)));
    }

    MethodExecutor postEmpty(String format, Object ... args) {
        HttpPost request = new HttpPost(RestExecutor.buildUrl(this.baseUrl, format, args));
        try {
            request.setEntity((HttpEntity)new StringEntity("", "application/xml", "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        return new MethodExecutor((HttpUriRequest)request);
    }

    MethodExecutor post(Object body, String format, Object ... args) {
        HttpPost request = new HttpPost(RestExecutor.buildUrl(this.baseUrl, format, args));
        RestExecutor.setBody((HttpEntityEnclosingRequest)request, body);
        return new MethodExecutor((HttpUriRequest)request);
    }

    MethodExecutor put(Object body, String format, Object ... args) {
        HttpPut request = new HttpPut(RestExecutor.buildUrl(this.baseUrl, format, args));
        RestExecutor.setBody((HttpEntityEnclosingRequest)request, body);
        return new MethodExecutor((HttpUriRequest)request);
    }

    private static void setBody(HttpEntityEnclosingRequest request, Object body) {
        ByteArrayOutputStream bs = RestExecutor.marshall(body);
        request.setEntity((HttpEntity)new ByteArrayEntity(bs.toByteArray(), ContentType.APPLICATION_XML));
    }

    static URI buildUrl(String baseUrl, String format, Object ... args) {
        String url = baseUrl;
        if (format != null) {
            url = String.valueOf(url) + (args == null || args.length == 0 ? format : String.format(format, args));
        }
        try {
            URI uri = new URIBuilder(url).build();
            log.debug("Constructed " + uri.toASCIIString());
            return uri;
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    static int pathArgumentCount(String format) {
        int queryStart = format.indexOf(63);
        if (queryStart == -1) {
            queryStart = format.length();
        }
        int count = 0;
        int i = format.indexOf(37);
        while (i != -1 && i < queryStart) {
            ++count;
            i = format.indexOf(37, i + 1);
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static JAXBContext getJAXBContext(Class type) throws JAXBException {
        Map<Class, JAXBContext> map = jaxbContexts;
        synchronized (map) {
            JAXBContext c = jaxbContexts.get(type);
            if (c == null) {
                c = JAXBContext.newInstance((Class[])new Class[]{type});
                jaxbContexts.put(type, c);
            }
            return c;
        }
    }

    private static Marshaller marshallerFor(Class type) throws JAXBException {
        Preconditions.checkNotNull((Object)type);
        Marshaller m = RestExecutor.getJAXBContext(type).createMarshaller();
        m.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        return m;
    }

    private static Unmarshaller unmarshallerFor(Class type) throws JAXBException {
        Preconditions.checkNotNull((Object)type);
        return RestExecutor.getJAXBContext(type).createUnmarshaller();
    }

    private static ByteArrayOutputStream marshall(Object body) {
        try {
            ByteArrayOutputStream bs = new ByteArrayOutputStream();
            RestExecutor.marshallerFor(body.getClass()).marshal(body, (OutputStream)bs);
            return bs;
        }
        catch (JAXBException e) {
            throw new DataBindingException((Throwable)e);
        }
    }

    private <T> T unmarshall(Class<T> returnType, InputStream xml) {
        try {
            return (T)RestExecutor.unmarshallerFor(returnType).unmarshal(new InputSource(xml));
        }
        catch (JAXBException e) {
            throw new DataBindingException((Throwable)e);
        }
    }

    final class MethodExecutor {
        final HttpUriRequest request;

        private MethodExecutor(HttpUriRequest request) {
            this.request = request;
        }

        <T> T andReceive(Class<T> returnType) throws ApplicationPermissionException, InvalidAuthenticationException, OperationFailedException, CrowdRestException {
            this.request.setHeader("Accept", "application/xml");
            HttpResponse response = null;
            try {
                response = this.executeCrowdServiceMethod(this.request);
                if (!this.isSuccess(response)) {
                    this.throwError(response);
                    throw new OperationFailedException(response.getStatusLine().getReasonPhrase());
                }
                Object object = RestExecutor.this.unmarshall(returnType, response.getEntity().getContent());
                return (T)object;
            }
            catch (IOException e) {
                throw new OperationFailedException((Throwable)e);
            }
            finally {
                if (response != null) {
                    EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                }
            }
        }

        boolean doesExist() throws ApplicationPermissionException, InvalidAuthenticationException, OperationFailedException, CrowdRestException {
            HttpResponse response = null;
            try {
                response = this.executeCrowdServiceMethod(this.request);
                if (this.isSuccess(response)) {
                    return true;
                }
                if (response.getStatusLine().getStatusCode() == 404) {
                    return false;
                }
                try {
                    this.throwError(response);
                    throw new OperationFailedException(response.getStatusLine().getReasonPhrase());
                }
                catch (IOException e) {
                    throw new OperationFailedException((Throwable)e);
                }
            }
            finally {
                if (response != null) {
                    EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                }
            }
        }

        void andCheckResponse() throws ApplicationPermissionException, InvalidAuthenticationException, OperationFailedException, CrowdRestException {
            this.request.setHeader("Accept", "application/xml");
            HttpResponse response = null;
            try {
                try {
                    response = this.executeCrowdServiceMethod(this.request);
                    if (!this.isSuccess(response)) {
                        this.throwError(response);
                        throw new OperationFailedException(response.getStatusLine().getReasonPhrase());
                    }
                }
                catch (IOException e) {
                    throw new OperationFailedException((Throwable)e);
                }
            }
            finally {
                if (response != null) {
                    EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                }
            }
        }

        private boolean isSuccess(HttpResponse response) {
            int statusCode = response.getStatusLine().getStatusCode();
            return statusCode >= 200 && statusCode < 300;
        }

        private void throwError(HttpResponse response) throws ApplicationPermissionException, InvalidAuthenticationException, OperationFailedException, CrowdRestException {
            try {
                int errorCode = response.getStatusLine().getStatusCode();
                if (errorCode == 403) {
                    throw new ApplicationPermissionException(response.getEntity().toString());
                }
                if (errorCode == 401) {
                    throw new InvalidAuthenticationException(response.getEntity().toString());
                }
                if (errorCode >= 300) {
                    ErrorEntity errorEntity = (ErrorEntity)RestExecutor.this.unmarshall(ErrorEntity.class, response.getEntity().getContent());
                    throw new CrowdRestException(errorEntity.getMessage(), errorEntity, errorCode);
                }
            }
            catch (IOException iOException) {
                throw new OperationFailedException(response.getStatusLine().getReasonPhrase());
            }
        }

        private HttpResponse executeCrowdServiceMethod(HttpUriRequest uriRequest) throws InvalidCrowdServiceException, IOException {
            HttpResponse httpResponse;
            Preconditions.checkState((hc4Client != null ? 1 : 0) != 0, (Object)"HC4Client was not set");
            BasicHttpContext context = new BasicHttpContext();
            if (RestExecutor.this.useTrustStore) {
                context.setAttribute("nexus.httpclient.ssl.trustStore", (Object)Boolean.TRUE);
            }
            if (!this.isCrowdRestService(httpResponse = hc4Client.get(RestExecutor.this.applicationName, RestExecutor.this.applicationPassword, RestExecutor.this.httpTimeout).execute(uriRequest, (HttpContext)context))) {
                log.warn(RestExecutor.INVALID_REST_SERVICE_MSG_FORMAT.replace("%s", "{}"), (Object)uriRequest.getURI().toASCIIString());
            }
            return httpResponse;
        }

        private boolean isCrowdRestService(HttpResponse response) {
            return response.getFirstHeader(RestExecutor.EMBEDDED_CROWD_VERSION_NAME) != null;
        }
    }
}

