/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.crowd.internal;

import com.atlassian.crowd.embedded.api.SearchRestriction;
import com.atlassian.crowd.search.query.entity.restriction.MatchMode;
import com.atlassian.crowd.search.query.entity.restriction.Property;
import com.atlassian.crowd.search.query.entity.restriction.PropertyImpl;
import com.atlassian.crowd.search.query.entity.restriction.TermRestriction;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.sonatype.nexus.crowd.Crowd;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.enterprise.inject.Typed;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.nexus.security.authz.AbstractReadOnlyAuthorizationManager;
import org.sonatype.nexus.security.authz.AuthorizationManager;
import org.sonatype.nexus.security.privilege.NoSuchPrivilegeException;
import org.sonatype.nexus.security.privilege.Privilege;
import org.sonatype.nexus.security.role.NoSuchRoleException;
import org.sonatype.nexus.security.role.Role;

@Named(value="Crowd")
@Typed(value={AuthorizationManager.class})
@Singleton
public class CrowdAuthorizationManager
extends AbstractReadOnlyAuthorizationManager {
    private static final Logger log = LoggerFactory.getLogger(CrowdAuthorizationManager.class);
    private static final String SOURCE = "Crowd";
    private static final Property<Boolean> ACTIVE = new PropertyImpl("active", Boolean.class);
    private final Crowd crowd;

    @Inject
    public CrowdAuthorizationManager(Crowd crowd) {
        this.crowd = (Crowd)Preconditions.checkNotNull((Object)crowd);
    }

    public String getSource() {
        return SOURCE;
    }

    public Set<Role> listRoles() {
        if (this.crowd.isEnabled()) {
            try {
                return this.convertToRoles(this.crowd.client().searchGroupNames((SearchRestriction)new TermRestriction(ACTIVE, MatchMode.EXACTLY_MATCHES, (Object)true), 0, Integer.MAX_VALUE));
            }
            catch (Exception e) {
                if (log.isDebugEnabled()) {
                    log.error("Unable to list roles", (Throwable)e);
                } else {
                    log.error("Unable to list roles due to {}/{}", (Object)e.getClass().getName(), (Object)e.getMessage());
                }
            }
        } else {
            log.debug("Crowd client is not enabled.");
        }
        return Collections.emptySet();
    }

    public Role getRole(String roleId) throws NoSuchRoleException {
        if (this.crowd.isEnabled()) {
            try {
                return this.convertToRole(this.crowd.client().getGroup(roleId).getName());
            }
            catch (Exception e) {
                throw new NoSuchRoleException(roleId, (Throwable)e);
            }
        }
        throw new IllegalStateException("Crowd client is not enabled.");
    }

    public Set<Privilege> listPrivileges() {
        return null;
    }

    public Privilege getPrivilege(String privilegeId) throws NoSuchPrivilegeException {
        return null;
    }

    private Set<Role> convertToRoles(List<String> roleNames) {
        return Sets.newHashSet((Iterable)Iterables.transform(roleNames, (Function)new Function<String, Role>(){

            public Role apply(String from) {
                return CrowdAuthorizationManager.this.convertToRole(from);
            }
        }));
    }

    private Role convertToRole(String from) {
        Role role = new Role();
        role.setRoleId(from);
        role.setName(from);
        role.setDescription(from);
        role.setReadOnly(true);
        role.setSource(this.getSource());
        return role;
    }
}

