/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.crowd.internal;

import com.atlassian.crowd.integration.rest.service.factory.RestCrowdClientFactory;
import com.atlassian.crowd.service.client.ClientProperties;
import com.atlassian.crowd.service.client.CrowdClient;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.sonatype.nexus.crowd.Crowd;
import com.sonatype.nexus.crowd.CrowdConfiguration;
import com.sonatype.nexus.crowd.internal.CrowdClientProperties;
import com.sonatype.nexus.crowd.internal.CrowdConfigurationChangedEvent;
import com.sonatype.nexus.crowd.internal.capability.CrowdCapability;
import com.sonatype.nexus.crowd.internal.capability.CrowdCapabilityDescriptor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Collection;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.capability.CapabilityReference;
import org.sonatype.nexus.capability.CapabilityReferenceFilterBuilder;
import org.sonatype.nexus.capability.CapabilityRegistry;
import org.sonatype.nexus.common.event.EventManager;
import org.sonatype.nexus.common.stateguard.StateGuardLifecycleSupport;
import org.sonatype.nexus.security.realm.RealmManager;

@Named
@Singleton
public class CrowdImpl
extends StateGuardLifecycleSupport
implements Crowd {
    private final EventManager eventManager;
    private final CapabilityRegistry capabilityRegistry;
    private final RestCrowdClientFactory clientFactory;
    private final RealmManager realmManager;
    private CrowdClient client;

    @Inject
    public CrowdImpl(EventManager eventManager, RealmManager realmManager, CapabilityRegistry capabilityRegistry) {
        this.eventManager = (EventManager)Preconditions.checkNotNull((Object)eventManager);
        this.realmManager = (RealmManager)Preconditions.checkNotNull((Object)realmManager);
        this.capabilityRegistry = (CapabilityRegistry)Preconditions.checkNotNull((Object)capabilityRegistry);
        this.clientFactory = new RestCrowdClientFactory();
    }

    @Override
    public Crowd configure(CrowdConfiguration config) {
        CapabilityReference reference = this.capabilityReference();
        if (reference != null) {
            this.capabilityRegistry.update(reference.context().id(), reference.context().isEnabled(), reference.context().notes(), config.asMap());
        } else {
            this.capabilityRegistry.add(CrowdCapabilityDescriptor.TYPE, true, null, config.asMap());
        }
        this.client = null;
        this.eventManager.post((Object)new CrowdConfigurationChangedEvent(config));
        return this;
    }

    @Override
    public CrowdConfiguration configuration() {
        CapabilityReference reference = this.capabilityReference();
        if (reference != null) {
            return (CrowdConfiguration)((Object)((CrowdCapability)reference.capabilityAs(CrowdCapability.class)).getConfig());
        }
        return null;
    }

    @Override
    public CrowdClient client() {
        CrowdConfiguration config = this.configuration();
        if (config == null) {
            return CrowdImpl.createInoperableClient(new IllegalStateException("Crowd not configured"));
        }
        if (!this.isEnabled()) {
            return CrowdImpl.createInoperableClient(new IllegalStateException("Crowd not enabled"));
        }
        if (this.client == null) {
            this.client = this.client(config);
        }
        return this.client;
    }

    @Override
    public CrowdClient client(CrowdConfiguration config) {
        CrowdClientProperties clientProperties = CrowdClientProperties.newInstanceFromProperties(config.getCrowdClientProperties());
        this.log.debug("Creating a new Crowd client using properties:\n" + config.getCrowdClientProperties());
        return this.clientFactory.newInstance((ClientProperties)clientProperties);
    }

    @Override
    public boolean isEnabled() {
        CapabilityReference ref = this.capabilityReference();
        if (ref == null) {
            return false;
        }
        return ref.context().isActive();
    }

    @Override
    public void setEnabled(boolean enable) {
        this.log.debug("Enabled: {}", (Object)enable);
        CapabilityReference ref = this.capabilityReference();
        if (enable) {
            Preconditions.checkState((ref != null ? 1 : 0) != 0, (Object)"Crowd capability was not yet configured");
            this.capabilityRegistry.enable(ref.context().id());
        } else if (ref != null) {
            this.capabilityRegistry.disable(ref.context().id());
        }
    }

    @Override
    public boolean isRealmActive() {
        return this.realmManager.isRealmEnabled("Crowd");
    }

    @Override
    public void setRealmActive(boolean enabled) {
        this.realmManager.enableRealm("Crowd", enabled);
    }

    @Nullable
    private CapabilityReference capabilityReference() {
        Collection refs = this.capabilityRegistry.get((Predicate)CapabilityReferenceFilterBuilder.capabilities().withType(CrowdCapabilityDescriptor.TYPE));
        if (refs.isEmpty()) {
            return null;
        }
        return (CapabilityReference)refs.iterator().next();
    }

    private static CrowdClient createInoperableClient(final Throwable cause) {
        return (CrowdClient)Proxy.newProxyInstance(CrowdImpl.class.getClassLoader(), new Class[]{CrowdClient.class}, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                throw cause;
            }
        });
    }
}

