/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.crowd.internal;

import com.google.common.base.Preconditions;
import com.google.common.eventbus.Subscribe;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.client.HttpClient;
import org.eclipse.sisu.Dynamic;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.goodies.common.Time;
import org.sonatype.nexus.common.event.EventAware;
import org.sonatype.nexus.httpclient.HttpClientManager;
import org.sonatype.nexus.httpclient.HttpClientPlan;
import org.sonatype.nexus.httpclient.PreemptiveAuthHttpRequestInterceptor;
import org.sonatype.nexus.httpclient.config.AuthenticationConfiguration;
import org.sonatype.nexus.httpclient.config.ConfigurationCustomizer;
import org.sonatype.nexus.httpclient.config.ConnectionConfiguration;
import org.sonatype.nexus.httpclient.config.HttpClientConfiguration;
import org.sonatype.nexus.httpclient.config.HttpClientConfigurationChangedEvent;
import org.sonatype.nexus.httpclient.config.UsernameAuthenticationConfiguration;

@Named
@Singleton
public class Hc4Client
extends ComponentSupport
implements EventAware {
    private final HttpClientManager httpClientManager;
    private volatile HttpClient httpClient;
    private String applicationName;
    private String applicationPassword;
    private Integer httpTimeout;

    @Inject
    public Hc4Client(@Dynamic HttpClientManager httpClientManager) {
        this.httpClientManager = (HttpClientManager)Preconditions.checkNotNull((Object)httpClientManager);
    }

    public HttpClient get(String applicationName, String applicationPassword, Integer httpTimeout) {
        if (!(this.httpClient != null && Objects.equals(applicationName, this.applicationName) && Objects.equals(applicationPassword, this.applicationPassword) && Objects.equals(httpTimeout, this.httpTimeout))) {
            HttpClientConfiguration configuration = new HttpClientConfiguration();
            UsernameAuthenticationConfiguration authentication = new UsernameAuthenticationConfiguration();
            authentication.setUsername(applicationName);
            authentication.setPassword(applicationPassword);
            configuration.setAuthentication((AuthenticationConfiguration)authentication);
            if (httpTimeout != null) {
                ConnectionConfiguration connection = new ConnectionConfiguration();
                connection.setTimeout(Time.seconds((long)httpTimeout.intValue()));
                configuration.setConnection(connection);
            }
            this.httpClient = this.httpClientManager.create((HttpClientPlan.Customizer)new ConfigurationCustomizer(configuration){

                public void customize(HttpClientPlan plan) {
                    super.customize(plan);
                    plan.getClient().addInterceptorFirst((HttpRequestInterceptor)new PreemptiveAuthHttpRequestInterceptor());
                }
            });
            this.applicationName = applicationName;
            this.applicationPassword = applicationPassword;
            this.httpTimeout = httpTimeout;
            this.log.debug("Created a new HTTP-client for Crowd; application-name: {}", (Object)applicationName);
        }
        return this.httpClient;
    }

    @Subscribe
    public void on(HttpClientConfigurationChangedEvent event) {
        this.httpClient = null;
    }
}

