/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.crowd.internal.capability;

import com.google.common.base.Preconditions;
import com.sonatype.nexus.crowd.CrowdConfiguration;
import com.sonatype.nexus.crowd.CrowdFeature;
import com.sonatype.nexus.crowd.internal.CrowdImpl;
import com.sonatype.nexus.licensing.ext.capability.LicensingConditions;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.goodies.i18n.I18N;
import org.sonatype.goodies.i18n.MessageBundle;
import org.sonatype.licensing.feature.Feature;
import org.sonatype.nexus.capability.CapabilitySupport;
import org.sonatype.nexus.capability.Condition;

@Named(value="crowd")
public class CrowdCapability
extends CapabilitySupport<CrowdConfiguration> {
    private static final Messages messages = (Messages)I18N.create(Messages.class);
    private final LicensingConditions licensingConditions;
    private final CrowdFeature crowdFeature;
    private final CrowdImpl crowd;

    @Inject
    public CrowdCapability(LicensingConditions licensingConditions, CrowdFeature crowdFeature, CrowdImpl crowd) {
        this.licensingConditions = (LicensingConditions)Preconditions.checkNotNull((Object)licensingConditions);
        this.crowdFeature = (CrowdFeature)((Object)Preconditions.checkNotNull((Object)((Object)crowdFeature)));
        this.crowd = (CrowdImpl)Preconditions.checkNotNull((Object)crowd);
    }

    protected CrowdConfiguration createConfig(Map<String, String> properties) {
        return new CrowdConfiguration(properties);
    }

    public Condition activationCondition() {
        return this.conditions().logical().and(new Condition[]{this.conditions().nexus().active(), this.licensingConditions.licenseIsValid((Feature)this.crowdFeature), this.conditions().capabilities().passivateCapabilityDuringUpdate()});
    }

    public void onActivate() throws Exception {
        this.crowd.start();
    }

    public void onPassivate() throws Exception {
        this.crowd.stop();
    }

    public String renderDescription() throws Exception {
        if (this.context().isActive()) {
            String realmState = this.crowd.isRealmActive() ? messages.active() : messages.inactive();
            return messages.description(realmState, this.crowd.configuration().getCrowdServerUrl());
        }
        return messages.disabledDescription();
    }

    private static interface Messages
    extends MessageBundle {
        @MessageBundle.DefaultMessage(value="active")
        public String active();

        @MessageBundle.DefaultMessage(value="inactive")
        public String inactive();

        @MessageBundle.DefaultMessage(value="Realm %s, Server: %s")
        public String description(String var1, String var2);

        @MessageBundle.DefaultMessage(value="Crowd disabled")
        public String disabledDescription();
    }
}

