/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.crowd.internal.capability;

import com.google.common.collect.Lists;
import com.sonatype.nexus.crowd.CrowdConfiguration;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.i18n.I18N;
import org.sonatype.goodies.i18n.MessageBundle;
import org.sonatype.nexus.capability.CapabilityDescriptorSupport;
import org.sonatype.nexus.capability.CapabilityType;
import org.sonatype.nexus.capability.Tag;
import org.sonatype.nexus.capability.Taggable;
import org.sonatype.nexus.formfields.CheckboxFormField;
import org.sonatype.nexus.formfields.FormField;
import org.sonatype.nexus.formfields.NumberTextFormField;
import org.sonatype.nexus.formfields.PasswordFormField;
import org.sonatype.nexus.formfields.StringTextFormField;
import org.sonatype.nexus.formfields.UrlFormField;

@Named(value="crowd")
@Singleton
public class CrowdCapabilityDescriptor
extends CapabilityDescriptorSupport<CrowdConfiguration>
implements Taggable {
    public static final String TYPE_ID = "crowd";
    public static final CapabilityType TYPE = CapabilityType.capabilityType((String)"crowd");
    private static final Messages messages = (Messages)I18N.create(Messages.class);
    private final List<FormField> formFields = Lists.newArrayList((Object[])new FormField[]{new UrlFormField("crowdServerUrl", messages.crowdServerUrlLabel(), messages.crowdServerUrlHelp(), true), new CheckboxFormField("useTrustStore", messages.useTrustStoreLabel(), null, false), new StringTextFormField("applicationName", messages.applicationNameLabel(), messages.applicationNameHelp(), true), new PasswordFormField("applicationPassword", messages.applicationPasswordLabel(), messages.applicationPasswordHelp(), true), new NumberTextFormField("httpTimeout", messages.httpTimeoutLabel(), messages.httpTimeoutHelp(), false)});

    @Inject
    public CrowdCapabilityDescriptor() {
    }

    public CapabilityType type() {
        return TYPE;
    }

    public String name() {
        return messages.name();
    }

    public List<FormField> formFields() {
        return this.formFields;
    }

    protected CrowdConfiguration createConfig(Map<String, String> properties) {
        return new CrowdConfiguration(properties);
    }

    protected String renderAbout() throws Exception {
        return this.render("crowd-about.vm");
    }

    public Set<Tag> getTags() {
        return Tag.tags((Tag[])new Tag[]{Tag.categoryTag((String)"Security")});
    }

    private static interface Messages
    extends MessageBundle {
        @MessageBundle.DefaultMessage(value="Crowd")
        public String name();

        @MessageBundle.DefaultMessage(value="Application Name")
        public String applicationNameLabel();

        @MessageBundle.DefaultMessage(value="The name of the Application to use when establishing a connection to the Crowd server.")
        public String applicationNameHelp();

        @MessageBundle.DefaultMessage(value="Application Password")
        public String applicationPasswordLabel();

        @MessageBundle.DefaultMessage(value="The password to use when authenticating the Application connection to the Crowd server.")
        public String applicationPasswordHelp();

        @MessageBundle.DefaultMessage(value="Crowd Server URL")
        public String crowdServerUrlLabel();

        @MessageBundle.DefaultMessage(value="The URL of the Crowd server. Example: http://localhost:8095/crowd")
        public String crowdServerUrlHelp();

        @MessageBundle.DefaultMessage(value="Use the Nexus truststore")
        public String useTrustStoreLabel();

        @MessageBundle.DefaultMessage(value="Request Timeout")
        public String httpTimeoutLabel();

        @MessageBundle.DefaultMessage(value="The HTTP connection timeout (seconds) used for communication with the Crowd server. A value of zero indicates that there is no connection timeout. Leave the field blank to use the globally defined http timeout.")
        public String httpTimeoutHelp();
    }
}

