/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queries;

import com.google.common.primitives.Ints;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexReaderContext;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermContext;
import org.apache.lucene.index.TermState;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.DisjunctionMaxQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.InPlaceMergeSorter;
import org.apache.lucene.util.ToStringUtils;

public abstract class BlendedTermQuery
extends Query {
    private final Term[] terms;
    private final float[] boosts;
    private volatile Term[] equalTerms = null;

    public BlendedTermQuery(Term[] terms, float[] boosts) {
        if (terms == null || terms.length == 0) {
            throw new IllegalArgumentException("terms must not be null or empty");
        }
        if (boosts != null && boosts.length != terms.length) {
            throw new IllegalArgumentException("boosts must have the same size as terms");
        }
        this.terms = terms;
        this.boosts = boosts;
    }

    @Override
    public Query rewrite(IndexReader reader) throws IOException {
        IndexReaderContext context = reader.getContext();
        TermContext[] ctx = new TermContext[this.terms.length];
        int[] docFreqs = new int[ctx.length];
        for (int i = 0; i < this.terms.length; ++i) {
            ctx[i] = TermContext.build(context, this.terms[i]);
            docFreqs[i] = ctx[i].docFreq();
        }
        int maxDoc = reader.maxDoc();
        this.blend(ctx, maxDoc, reader);
        Query query = this.topLevelQuery(this.terms, ctx, docFreqs, maxDoc);
        query.setBoost(this.getBoost());
        return query;
    }

    protected abstract Query topLevelQuery(Term[] var1, TermContext[] var2, int[] var3, int var4);

    protected void blend(final TermContext[] contexts, int maxDoc, IndexReader reader) throws IOException {
        int i;
        TermContext ctx;
        if (contexts.length <= 1) {
            return;
        }
        int max = 0;
        long minSumTTF = Long.MAX_VALUE;
        for (int i2 = 0; i2 < contexts.length; ++i2) {
            TermContext ctx2 = contexts[i2];
            int df = ctx2.docFreq();
            max = Math.max(df, max);
            minSumTTF = minSumTTF != -1L && ctx2.totalTermFreq() != -1L ? Math.min(minSumTTF, reader.getSumTotalTermFreq(this.terms[i2].field())) : -1L;
        }
        if (minSumTTF != -1L && (long)maxDoc > minSumTTF) {
            maxDoc = (int)minSumTTF;
        }
        if (max == 0) {
            return;
        }
        long sumTTF = minSumTTF == -1L ? -1L : 0L;
        final int[] tieBreak = new int[contexts.length];
        for (int i3 = 0; i3 < tieBreak.length; ++i3) {
            tieBreak[i3] = i3;
        }
        new InPlaceMergeSorter(){

            @Override
            protected void swap(int i, int j) {
                int tmp = tieBreak[i];
                tieBreak[i] = tieBreak[j];
                tieBreak[j] = tmp;
            }

            @Override
            protected int compare(int i, int j) {
                return Ints.compare((int)contexts[tieBreak[j]].docFreq(), (int)contexts[tieBreak[i]].docFreq());
            }
        }.sort(0, tieBreak.length);
        int prev = contexts[tieBreak[0]].docFreq();
        int actualDf = Math.min(maxDoc, max);
        assert (actualDf >= 0) : "DF must be >= 0";
        int[] arr$ = tieBreak;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$ && (ctx = contexts[i = arr$[i$]]).docFreq() != 0; ++i$) {
            int current = ctx.docFreq();
            if (prev > current) {
                ++actualDf;
            }
            contexts[i] = ctx = BlendedTermQuery.adjustDF(ctx, Math.min(maxDoc, actualDf));
            prev = current;
            if (sumTTF >= 0L && ctx.totalTermFreq() >= 0L) {
                sumTTF += ctx.totalTermFreq();
                continue;
            }
            sumTTF = -1L;
        }
        sumTTF = Math.min(sumTTF, minSumTTF);
        for (int i4 = 0; i4 < contexts.length; ++i4) {
            int df = contexts[i4].docFreq();
            if (df == 0) continue;
            long fixedTTF = sumTTF == -1L ? -1L : sumTTF;
            contexts[i4] = this.adjustTTF(contexts[i4], fixedTTF);
        }
    }

    private TermContext adjustTTF(TermContext termContext, long sumTTF) {
        if (sumTTF == -1L && termContext.totalTermFreq() == -1L) {
            return termContext;
        }
        TermContext newTermContext = new TermContext(termContext.topReaderContext);
        List<LeafReaderContext> leaves = termContext.topReaderContext.leaves();
        int len = leaves == null ? 1 : leaves.size();
        int df = termContext.docFreq();
        long ttf = sumTTF;
        for (int i = 0; i < len; ++i) {
            TermState termState = termContext.get(i);
            if (termState == null) continue;
            newTermContext.register(termState, i, df, ttf);
            df = 0;
            ttf = 0L;
        }
        return newTermContext;
    }

    private static TermContext adjustDF(TermContext ctx, int newDocFreq) {
        long newTTF = ctx.totalTermFreq() < 0L ? -1L : Math.max(ctx.totalTermFreq(), (long)newDocFreq);
        List<LeafReaderContext> leaves = ctx.topReaderContext.leaves();
        int len = leaves == null ? 1 : leaves.size();
        TermContext newCtx = new TermContext(ctx.topReaderContext);
        for (int i = 0; i < len; ++i) {
            TermState termState = ctx.get(i);
            if (termState == null) continue;
            newCtx.register(termState, i, newDocFreq, newTTF);
            newDocFreq = 0;
            newTTF = 0L;
        }
        return newCtx;
    }

    @Override
    public String toString(String field) {
        StringBuilder builder = new StringBuilder("blended(terms:[");
        for (int i = 0; i < this.terms.length; ++i) {
            builder.append(this.terms[i]);
            float boost = 1.0f;
            if (this.boosts != null) {
                boost = this.boosts[i];
            }
            builder.append(ToStringUtils.boost(boost));
            builder.append(", ");
        }
        if (this.terms.length > 0) {
            builder.setLength(builder.length() - 2);
        }
        builder.append("])");
        builder.append(ToStringUtils.boost(this.getBoost()));
        return builder.toString();
    }

    private Term[] equalsTerms() {
        if (this.terms.length == 1) {
            return this.terms;
        }
        if (this.equalTerms == null) {
            Comparable[] t = new Term[this.terms.length];
            System.arraycopy(this.terms, 0, t, 0, this.terms.length);
            ArrayUtil.timSort((Comparable[])t);
            this.equalTerms = t;
        }
        return this.equalTerms;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        BlendedTermQuery that = (BlendedTermQuery)o;
        return Arrays.equals(this.equalsTerms(), that.equalsTerms());
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Arrays.hashCode(this.equalsTerms());
        return result;
    }

    public static BlendedTermQuery booleanBlendedQuery(Term[] terms, boolean disableCoord) {
        return BlendedTermQuery.booleanBlendedQuery(terms, null, disableCoord);
    }

    public static BlendedTermQuery booleanBlendedQuery(Term[] terms, final float[] boosts, final boolean disableCoord) {
        return new BlendedTermQuery(terms, boosts){

            @Override
            protected Query topLevelQuery(Term[] terms, TermContext[] ctx, int[] docFreqs, int maxDoc) {
                BooleanQuery.Builder query = new BooleanQuery.Builder();
                query.setDisableCoord(disableCoord);
                for (int i = 0; i < terms.length; ++i) {
                    TermQuery termQuery = new TermQuery(terms[i], ctx[i]);
                    if (boosts != null) {
                        termQuery.setBoost(boosts[i]);
                    }
                    query.add(termQuery, BooleanClause.Occur.SHOULD);
                }
                return query.build();
            }
        };
    }

    public static BlendedTermQuery commonTermsBlendedQuery(Term[] terms, final float[] boosts, final boolean disableCoord, final float maxTermFrequency) {
        return new BlendedTermQuery(terms, boosts){

            @Override
            protected Query topLevelQuery(Term[] terms, TermContext[] ctx, int[] docFreqs, int maxDoc) {
                BooleanQuery.Builder highBuilder = new BooleanQuery.Builder();
                highBuilder.setDisableCoord(disableCoord);
                BooleanQuery.Builder lowBuilder = new BooleanQuery.Builder();
                lowBuilder.setDisableCoord(disableCoord);
                for (int i = 0; i < terms.length; ++i) {
                    TermQuery termQuery = new TermQuery(terms[i], ctx[i]);
                    if (boosts != null) {
                        termQuery.setBoost(boosts[i]);
                    }
                    if (maxTermFrequency >= 1.0f && (float)docFreqs[i] > maxTermFrequency || docFreqs[i] > (int)Math.ceil(maxTermFrequency * (float)maxDoc)) {
                        highBuilder.add(termQuery, BooleanClause.Occur.SHOULD);
                        continue;
                    }
                    lowBuilder.add(termQuery, BooleanClause.Occur.SHOULD);
                }
                BooleanQuery high = highBuilder.build();
                BooleanQuery low = lowBuilder.build();
                if (low.clauses().isEmpty()) {
                    BooleanQuery.Builder queryBuilder = new BooleanQuery.Builder();
                    queryBuilder.setDisableCoord(disableCoord);
                    for (BooleanClause booleanClause : high) {
                        queryBuilder.add(booleanClause.getQuery(), BooleanClause.Occur.MUST);
                    }
                    return queryBuilder.build();
                }
                if (high.clauses().isEmpty()) {
                    return low;
                }
                return new BooleanQuery.Builder().setDisableCoord(true).add(high, BooleanClause.Occur.SHOULD).add(low, BooleanClause.Occur.MUST).build();
            }
        };
    }

    public static BlendedTermQuery dismaxBlendedQuery(Term[] terms, float tieBreakerMultiplier) {
        return BlendedTermQuery.dismaxBlendedQuery(terms, null, tieBreakerMultiplier);
    }

    public static BlendedTermQuery dismaxBlendedQuery(Term[] terms, final float[] boosts, final float tieBreakerMultiplier) {
        return new BlendedTermQuery(terms, boosts){

            @Override
            protected Query topLevelQuery(Term[] terms, TermContext[] ctx, int[] docFreqs, int maxDoc) {
                DisjunctionMaxQuery query = new DisjunctionMaxQuery(tieBreakerMultiplier);
                for (int i = 0; i < terms.length; ++i) {
                    TermQuery termQuery = new TermQuery(terms[i], ctx[i]);
                    if (boosts != null) {
                        termQuery.setBoost(boosts[i]);
                    }
                    query.add(termQuery);
                }
                return query;
            }
        };
    }
}

