/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.join;

import java.io.IOException;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.search.SimpleCollector;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.NumericUtils;

abstract class DocValuesTermsCollector<DV>
extends SimpleCollector {
    protected DV docValues;
    private final Function<DV> docValuesCall;

    public DocValuesTermsCollector(Function<DV> docValuesCall) {
        this.docValuesCall = docValuesCall;
    }

    @Override
    protected final void doSetNextReader(LeafReaderContext context) throws IOException {
        this.docValues = this.docValuesCall.apply(context.reader());
    }

    static Function<BinaryDocValues> binaryDocValues(final String field) {
        return new Function<BinaryDocValues>(){

            @Override
            public BinaryDocValues apply(LeafReader ctx) throws IOException {
                return DocValues.getBinary(ctx, field);
            }
        };
    }

    static Function<SortedSetDocValues> sortedSetDocValues(final String field) {
        return new Function<SortedSetDocValues>(){

            @Override
            public SortedSetDocValues apply(LeafReader ctx) throws IOException {
                return DocValues.getSortedSet(ctx, field);
            }
        };
    }

    static Function<BinaryDocValues> numericAsBinaryDocValues(final String field, final FieldType.NumericType numTyp) {
        return new Function<BinaryDocValues>(){

            @Override
            public BinaryDocValues apply(LeafReader ctx) throws IOException {
                final NumericDocValues numeric = DocValues.getNumeric(ctx, field);
                final BytesRefBuilder bytes = new BytesRefBuilder();
                final LongConsumer coder = DocValuesTermsCollector.coder(bytes, numTyp, field);
                return new BinaryDocValues(){

                    @Override
                    public BytesRef get(int docID) {
                        long lVal = numeric.get(docID);
                        coder.accept(lVal);
                        return bytes.get();
                    }
                };
            }
        };
    }

    static LongConsumer coder(final BytesRefBuilder bytes, FieldType.NumericType type, String fieldName) {
        switch (type) {
            case INT: {
                return new LongConsumer(){

                    @Override
                    public void accept(long value) {
                        NumericUtils.intToPrefixCoded((int)value, 0, bytes);
                    }
                };
            }
            case LONG: {
                return new LongConsumer(){

                    @Override
                    public void accept(long value) {
                        NumericUtils.longToPrefixCoded((int)value, 0, bytes);
                    }
                };
            }
        }
        throw new IllegalArgumentException("Unsupported " + (Object)((Object)type) + ". Only " + (Object)((Object)FieldType.NumericType.INT) + " and " + (Object)((Object)FieldType.NumericType.LONG) + " are supported." + "Field " + fieldName);
    }

    static Function<SortedSetDocValues> sortedNumericAsSortedSetDocValues(final String field, final FieldType.NumericType numTyp) {
        return new Function<SortedSetDocValues>(){

            @Override
            public SortedSetDocValues apply(LeafReader ctx) throws IOException {
                final SortedNumericDocValues numerics = DocValues.getSortedNumeric(ctx, field);
                final BytesRefBuilder bytes = new BytesRefBuilder();
                final LongConsumer coder = DocValuesTermsCollector.coder(bytes, numTyp, field);
                return new SortedSetDocValues(){
                    private int index = Integer.MIN_VALUE;

                    @Override
                    public long nextOrd() {
                        return this.index < numerics.count() - 1 ? (long)(++this.index) : -1L;
                    }

                    @Override
                    public void setDocument(int docID) {
                        numerics.setDocument(docID);
                        this.index = -1;
                    }

                    @Override
                    public BytesRef lookupOrd(long ord) {
                        assert (ord >= 0L && ord < (long)numerics.count());
                        long value = numerics.valueAt((int)ord);
                        coder.accept(value);
                        return bytes.get();
                    }

                    @Override
                    public long getValueCount() {
                        throw new UnsupportedOperationException("it's just number encoding wrapper");
                    }

                    @Override
                    public long lookupTerm(BytesRef key) {
                        throw new UnsupportedOperationException("it's just number encoding wrapper");
                    }
                };
            }
        };
    }

    static interface LongConsumer {
        public void accept(long var1);
    }

    static interface Function<R> {
        public R apply(LeafReader var1) throws IOException;
    }
}

