/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.join;

import java.io.IOException;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.search.LeafCollector;
import org.apache.lucene.search.join.DocValuesTermsCollector;
import org.apache.lucene.search.join.GenericTermsCollector;
import org.apache.lucene.search.join.ScoreMode;
import org.apache.lucene.search.join.TermsCollector;
import org.apache.lucene.search.join.TermsWithScoreCollector;
import org.apache.lucene.util.BytesRefHash;

final class GenericTermsCollectorFactory {
    private GenericTermsCollectorFactory() {
    }

    static GenericTermsCollector createCollectorMV(DocValuesTermsCollector.Function<SortedSetDocValues> mvFunction, ScoreMode mode) {
        switch (mode) {
            case None: {
                return GenericTermsCollectorFactory.wrap(new TermsCollector.MV(mvFunction));
            }
            case Avg: {
                return new TermsWithScoreCollector.MV.Avg(mvFunction);
            }
        }
        return new TermsWithScoreCollector.MV(mvFunction, mode);
    }

    static GenericTermsCollector createCollectorSV(DocValuesTermsCollector.Function<BinaryDocValues> svFunction, ScoreMode mode) {
        switch (mode) {
            case None: {
                return GenericTermsCollectorFactory.wrap(new TermsCollector.SV(svFunction));
            }
            case Avg: {
                return new TermsWithScoreCollector.SV.Avg(svFunction);
            }
        }
        return new TermsWithScoreCollector.SV(svFunction, mode);
    }

    static GenericTermsCollector wrap(final TermsCollector<?> collector) {
        return new GenericTermsCollector(){

            @Override
            public LeafCollector getLeafCollector(LeafReaderContext context) throws IOException {
                return collector.getLeafCollector(context);
            }

            @Override
            public boolean needsScores() {
                return collector.needsScores();
            }

            @Override
            public BytesRefHash getCollectedTerms() {
                return collector.getCollectorTerms();
            }

            @Override
            public float[] getScoresPerTerm() {
                throw new UnsupportedOperationException("scores are not available for " + collector);
            }
        };
    }
}

