/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.spatial.geopoint.search;

import java.io.IOException;
import java.util.Arrays;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.Query;
import org.apache.lucene.spatial.geopoint.document.GeoPointField;
import org.apache.lucene.spatial.geopoint.search.GeoPointInBBoxQuery;
import org.apache.lucene.spatial.geopoint.search.GeoPointInPolygonQueryImpl;
import org.apache.lucene.spatial.util.GeoRect;
import org.apache.lucene.spatial.util.GeoUtils;

public final class GeoPointInPolygonQuery
extends GeoPointInBBoxQuery {
    protected final double[] x;
    protected final double[] y;

    public GeoPointInPolygonQuery(String field, double[] polyLons, double[] polyLats) {
        this(field, GeoPointField.TermEncoding.PREFIX, GeoUtils.polyToBBox(polyLons, polyLats), polyLons, polyLats);
    }

    public GeoPointInPolygonQuery(String field, GeoPointField.TermEncoding termEncoding, double[] polyLons, double[] polyLats) {
        this(field, termEncoding, GeoUtils.polyToBBox(polyLons, polyLats), polyLons, polyLats);
    }

    private GeoPointInPolygonQuery(String field, GeoPointField.TermEncoding termEncoding, GeoRect bbox, double[] polyLons, double[] polyLats) {
        super(field, termEncoding, bbox.minLon, bbox.minLat, bbox.maxLon, bbox.maxLat);
        if (polyLats.length != polyLons.length) {
            throw new IllegalArgumentException("polyLats and polyLons must be equal length");
        }
        if (polyLats.length < 4) {
            throw new IllegalArgumentException("at least 4 polygon points required");
        }
        if (polyLats[0] != polyLats[polyLats.length - 1]) {
            throw new IllegalArgumentException("first and last points of the polygon must be the same (it must close itself): polyLats[0]=" + polyLats[0] + " polyLats[" + (polyLats.length - 1) + "]=" + polyLats[polyLats.length - 1]);
        }
        if (polyLons[0] != polyLons[polyLons.length - 1]) {
            throw new IllegalArgumentException("first and last points of the polygon must be the same (it must close itself): polyLons[0]=" + polyLons[0] + " polyLons[" + (polyLons.length - 1) + "]=" + polyLons[polyLons.length - 1]);
        }
        this.x = polyLons;
        this.y = polyLats;
    }

    @Override
    public Query rewrite(IndexReader reader) throws IOException {
        if (this.getBoost() != 1.0f) {
            return super.rewrite(reader);
        }
        return new GeoPointInPolygonQueryImpl(this.field, this.termEncoding, this, this.minLon, this.minLat, this.maxLon, this.maxLat);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        GeoPointInPolygonQuery that = (GeoPointInPolygonQuery)o;
        if (!Arrays.equals(this.x, that.x)) {
            return false;
        }
        return Arrays.equals(this.y, that.y);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.x != null ? Arrays.hashCode(this.x) : 0);
        result = 31 * result + (this.y != null ? Arrays.hashCode(this.y) : 0);
        return result;
    }

    @Override
    public String toString(String field) {
        assert (this.x.length == this.y.length);
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append(':');
        if (!this.getField().equals(field)) {
            sb.append(" field=");
            sb.append(this.getField());
            sb.append(':');
        }
        sb.append(" Points: ");
        for (int i = 0; i < this.x.length; ++i) {
            sb.append("[").append(this.x[i]).append(", ").append(this.y[i]).append("] ");
        }
        return sb.toString();
    }

    public double[] getLons() {
        return this.x;
    }

    public double[] getLats() {
        return this.y;
    }
}

