/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster;

import com.carrotsearch.hppc.cursors.ObjectCursor;
import com.carrotsearch.hppc.cursors.ObjectObjectCursor;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.elasticsearch.cluster.Diff;
import org.elasticsearch.cluster.Diffable;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public final class DiffableUtils {
    private DiffableUtils() {
    }

    public static <T extends Diffable<T>> Diff<ImmutableOpenMap<String, T>> diff(ImmutableOpenMap<String, T> before, ImmutableOpenMap<String, T> after) {
        assert (after != null && before != null);
        return new ImmutableOpenMapDiff<T>(before, after);
    }

    public static <T extends Diffable<T>> Diff<ImmutableMap<String, T>> diff(ImmutableMap<String, T> before, ImmutableMap<String, T> after) {
        assert (after != null && before != null);
        return new ImmutableMapDiff<T>(before, after);
    }

    public static <T extends Diffable<T>> Diff<ImmutableOpenMap<String, T>> readImmutableOpenMapDiff(StreamInput in, KeyedReader<T> keyedReader) throws IOException {
        return new ImmutableOpenMapDiff<T>(in, keyedReader);
    }

    public static <T extends Diffable<T>> Diff<ImmutableMap<String, T>> readImmutableMapDiff(StreamInput in, KeyedReader<T> keyedReader) throws IOException {
        return new ImmutableMapDiff<T>(in, keyedReader);
    }

    public static <T extends Diffable<T>> Diff<ImmutableOpenMap<String, T>> readImmutableOpenMapDiff(StreamInput in, T proto) throws IOException {
        return new ImmutableOpenMapDiff<T>(in, new PrototypeReader<T>(proto));
    }

    public static <T extends Diffable<T>> Diff<ImmutableMap<String, T>> readImmutableMapDiff(StreamInput in, T proto) throws IOException {
        return new ImmutableMapDiff<T>(in, new PrototypeReader<T>(proto));
    }

    private static abstract class MapDiff<T extends Diffable<T>, M>
    implements Diff<M> {
        protected final List<String> deletes = new ArrayList<String>();
        protected final Map<String, Diff<T>> diffs = Maps.newHashMap();
        protected final Map<String, T> adds = Maps.newHashMap();

        protected MapDiff() {
        }

        protected MapDiff(StreamInput in, KeyedReader<T> reader) throws IOException {
            int deletesCount = in.readVInt();
            for (int i = 0; i < deletesCount; ++i) {
                this.deletes.add(in.readString());
            }
            int diffsCount = in.readVInt();
            for (int i = 0; i < diffsCount; ++i) {
                String key = in.readString();
                Diff<T> diff = reader.readDiffFrom(in, key);
                this.diffs.put(key, diff);
            }
            int addsCount = in.readVInt();
            for (int i = 0; i < addsCount; ++i) {
                String key = in.readString();
                Diffable part = (Diffable)reader.readFrom(in, key);
                this.adds.put(key, part);
            }
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeVInt(this.deletes.size());
            for (String string : this.deletes) {
                out.writeString(string);
            }
            out.writeVInt(this.diffs.size());
            for (Map.Entry entry : this.diffs.entrySet()) {
                out.writeString((String)entry.getKey());
                ((Diff)entry.getValue()).writeTo(out);
            }
            out.writeVInt(this.adds.size());
            for (Map.Entry entry : this.adds.entrySet()) {
                out.writeString((String)entry.getKey());
                ((Diffable)entry.getValue()).writeTo(out);
            }
        }
    }

    private static class ImmutableOpenMapDiff<T extends Diffable<T>>
    extends MapDiff<T, ImmutableOpenMap<String, T>> {
        protected ImmutableOpenMapDiff(StreamInput in, KeyedReader<T> reader) throws IOException {
            super(in, reader);
        }

        public ImmutableOpenMapDiff(ImmutableOpenMap<String, T> before, ImmutableOpenMap<String, T> after) {
            assert (after != null && before != null);
            for (ObjectCursor objectCursor : before.keys()) {
                if (after.containsKey((String)objectCursor.value)) continue;
                this.deletes.add(objectCursor.value);
            }
            for (ObjectObjectCursor objectObjectCursor : after) {
                Diffable beforePart = (Diffable)before.get((String)objectObjectCursor.key);
                if (beforePart == null) {
                    this.adds.put(objectObjectCursor.key, objectObjectCursor.value);
                    continue;
                }
                if (((Diffable)objectObjectCursor.value).equals(beforePart)) continue;
                this.diffs.put(objectObjectCursor.key, ((Diffable)objectObjectCursor.value).diff(beforePart));
            }
        }

        @Override
        public ImmutableOpenMap<String, T> apply(ImmutableOpenMap<String, T> map) {
            ImmutableOpenMap.Builder<String, Object> builder = ImmutableOpenMap.builder();
            builder.putAll(map);
            for (String string : this.deletes) {
                builder.remove(string);
            }
            for (Map.Entry entry : this.diffs.entrySet()) {
                builder.put((String)entry.getKey(), ((Diff)entry.getValue()).apply(builder.get((String)entry.getKey())));
            }
            for (Map.Entry entry : this.adds.entrySet()) {
                builder.put((String)entry.getKey(), entry.getValue());
            }
            return builder.build();
        }
    }

    private static class ImmutableMapDiff<T extends Diffable<T>>
    extends MapDiff<T, ImmutableMap<String, T>> {
        protected ImmutableMapDiff(StreamInput in, KeyedReader<T> reader) throws IOException {
            super(in, reader);
        }

        public ImmutableMapDiff(ImmutableMap<String, T> before, ImmutableMap<String, T> after) {
            assert (after != null && before != null);
            for (String key : before.keySet()) {
                if (after.containsKey((Object)key)) continue;
                this.deletes.add(key);
            }
            for (Map.Entry partIter : after.entrySet()) {
                Diffable beforePart = (Diffable)before.get(partIter.getKey());
                if (beforePart == null) {
                    this.adds.put(partIter.getKey(), partIter.getValue());
                    continue;
                }
                if (((Diffable)partIter.getValue()).equals(beforePart)) continue;
                this.diffs.put(partIter.getKey(), ((Diffable)partIter.getValue()).diff(beforePart));
            }
        }

        @Override
        public ImmutableMap<String, T> apply(ImmutableMap<String, T> map) {
            HashMap builder = Maps.newHashMap();
            builder.putAll(map);
            for (String string : this.deletes) {
                builder.remove(string);
            }
            for (Map.Entry entry : this.diffs.entrySet()) {
                builder.put(entry.getKey(), ((Diff)entry.getValue()).apply(builder.get(entry.getKey())));
            }
            for (Map.Entry entry : this.adds.entrySet()) {
                builder.put(entry.getKey(), entry.getValue());
            }
            return ImmutableMap.copyOf((Map)builder);
        }
    }

    public static class PrototypeReader<T extends Diffable<T>>
    implements KeyedReader<T> {
        private T proto;

        public PrototypeReader(T proto) {
            this.proto = proto;
        }

        @Override
        public T readFrom(StreamInput in, String key) throws IOException {
            return (T)((Diffable)this.proto.readFrom(in));
        }

        @Override
        public Diff<T> readDiffFrom(StreamInput in, String key) throws IOException {
            return this.proto.readDiffFrom(in);
        }
    }

    public static interface KeyedReader<T> {
        public T readFrom(StreamInput var1, String var2) throws IOException;

        public Diff<T> readDiffFrom(StreamInput var1, String var2) throws IOException;
    }
}

