/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.routing.allocation;

import com.carrotsearch.hppc.cursors.ObjectCursor;
import com.google.common.base.Function;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.elasticsearch.cluster.ClusterInfoService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.health.ClusterHealthStatus;
import org.elasticsearch.cluster.health.ClusterStateHealth;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.routing.IndexRoutingTable;
import org.elasticsearch.cluster.routing.RoutingNode;
import org.elasticsearch.cluster.routing.RoutingNodes;
import org.elasticsearch.cluster.routing.RoutingTable;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.UnassignedInfo;
import org.elasticsearch.cluster.routing.allocation.FailedRerouteAllocation;
import org.elasticsearch.cluster.routing.allocation.RoutingAllocation;
import org.elasticsearch.cluster.routing.allocation.RoutingExplanations;
import org.elasticsearch.cluster.routing.allocation.StartedRerouteAllocation;
import org.elasticsearch.cluster.routing.allocation.allocator.ShardsAllocators;
import org.elasticsearch.cluster.routing.allocation.command.AllocationCommands;
import org.elasticsearch.cluster.routing.allocation.decider.AllocationDeciders;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;

public class AllocationService
extends AbstractComponent {
    private final AllocationDeciders allocationDeciders;
    private final ClusterInfoService clusterInfoService;
    private final ShardsAllocators shardsAllocators;

    @Inject
    public AllocationService(Settings settings, AllocationDeciders allocationDeciders, ShardsAllocators shardsAllocators, ClusterInfoService clusterInfoService) {
        super(settings);
        this.allocationDeciders = allocationDeciders;
        this.shardsAllocators = shardsAllocators;
        this.clusterInfoService = clusterInfoService;
    }

    public RoutingAllocation.Result applyStartedShards(ClusterState clusterState, List<? extends ShardRouting> startedShards) {
        return this.applyStartedShards(clusterState, startedShards, true);
    }

    public RoutingAllocation.Result applyStartedShards(ClusterState clusterState, List<? extends ShardRouting> startedShards, boolean withReroute) {
        RoutingNodes routingNodes = this.getMutableRoutingNodes(clusterState);
        routingNodes.unassigned().shuffle();
        StartedRerouteAllocation allocation = new StartedRerouteAllocation(this.allocationDeciders, routingNodes, clusterState.nodes(), startedShards, this.clusterInfoService.getClusterInfo());
        boolean changed = this.applyStartedShards(routingNodes, startedShards);
        if (!changed) {
            return new RoutingAllocation.Result(false, clusterState.routingTable());
        }
        this.shardsAllocators.applyStartedShards(allocation);
        if (withReroute) {
            this.reroute(allocation);
        }
        RoutingTable routingTable = new RoutingTable.Builder().updateNodes(routingNodes).build().validateRaiseException(clusterState.metaData());
        RoutingAllocation.Result result = new RoutingAllocation.Result(true, routingTable);
        String startedShardsAsString = this.firstListElementsToCommaDelimitedString(startedShards, new Function<ShardRouting, String>(){

            public String apply(ShardRouting s) {
                return s.shardId().toString();
            }
        });
        this.logClusterHealthStateChange(new ClusterStateHealth(clusterState), new ClusterStateHealth(clusterState.metaData(), routingTable), "shards started [" + startedShardsAsString + "] ...");
        return result;
    }

    public RoutingAllocation.Result applyFailedShard(ClusterState clusterState, ShardRouting failedShard) {
        return this.applyFailedShards(clusterState, Collections.singletonList(new FailedRerouteAllocation.FailedShard(failedShard, null, null)));
    }

    public RoutingAllocation.Result applyFailedShards(ClusterState clusterState, List<FailedRerouteAllocation.FailedShard> failedShards) {
        RoutingNodes routingNodes = this.getMutableRoutingNodes(clusterState);
        routingNodes.unassigned().shuffle();
        FailedRerouteAllocation allocation = new FailedRerouteAllocation(this.allocationDeciders, routingNodes, clusterState.nodes(), failedShards, this.clusterInfoService.getClusterInfo());
        boolean changed = false;
        for (FailedRerouteAllocation.FailedShard failedShard : failedShards) {
            changed |= this.applyFailedShard(allocation, failedShard.shard, true, new UnassignedInfo(UnassignedInfo.Reason.ALLOCATION_FAILED, failedShard.message, failedShard.failure, System.nanoTime(), System.currentTimeMillis()));
        }
        if (!changed) {
            return new RoutingAllocation.Result(false, clusterState.routingTable());
        }
        this.shardsAllocators.applyFailedShards(allocation);
        this.reroute(allocation);
        RoutingTable routingTable = new RoutingTable.Builder().updateNodes(routingNodes).build().validateRaiseException(clusterState.metaData());
        RoutingAllocation.Result result = new RoutingAllocation.Result(true, routingTable);
        String failedShardsAsString = this.firstListElementsToCommaDelimitedString(failedShards, new Function<FailedRerouteAllocation.FailedShard, String>(){

            public String apply(FailedRerouteAllocation.FailedShard s) {
                return s.shard.shardId().toString();
            }
        });
        this.logClusterHealthStateChange(new ClusterStateHealth(clusterState), new ClusterStateHealth(clusterState.getMetaData(), routingTable), "shards failed [" + failedShardsAsString + "] ...");
        return result;
    }

    private <T> String firstListElementsToCommaDelimitedString(List<T> elements, Function<? super T, String> formatter) {
        int maxNumberOfElements = 10;
        Iterator<T> it = elements.iterator();
        StringBuilder msg = new StringBuilder();
        for (int currentIndex = 0; it.hasNext() && currentIndex < 10; ++currentIndex) {
            T element = it.next();
            if (currentIndex > 0) {
                msg.append(", ");
            }
            msg.append((String)formatter.apply(element));
        }
        return msg.toString();
    }

    public RoutingAllocation.Result reroute(ClusterState clusterState, AllocationCommands commands) {
        return this.reroute(clusterState, commands, false);
    }

    public RoutingAllocation.Result reroute(ClusterState clusterState, AllocationCommands commands, boolean explain) {
        RoutingNodes routingNodes = this.getMutableRoutingNodes(clusterState);
        RoutingAllocation allocation = new RoutingAllocation(this.allocationDeciders, routingNodes, clusterState.nodes(), this.clusterInfoService.getClusterInfo(), this.currentNanoTime());
        allocation.debugDecision(true);
        allocation.ignoreDisable(true);
        RoutingExplanations explanations = commands.execute(allocation, explain);
        allocation.ignoreDisable(false);
        this.reroute(allocation);
        RoutingTable routingTable = new RoutingTable.Builder().updateNodes(routingNodes).build().validateRaiseException(clusterState.metaData());
        RoutingAllocation.Result result = new RoutingAllocation.Result(true, routingTable, explanations);
        this.logClusterHealthStateChange(new ClusterStateHealth(clusterState), new ClusterStateHealth(clusterState.getMetaData(), routingTable), "reroute commands");
        return result;
    }

    public RoutingAllocation.Result reroute(ClusterState clusterState, String reason) {
        return this.reroute(clusterState, reason, false);
    }

    protected RoutingAllocation.Result reroute(ClusterState clusterState, String reason, boolean debug) {
        RoutingNodes routingNodes = this.getMutableRoutingNodes(clusterState);
        routingNodes.unassigned().shuffle();
        RoutingAllocation allocation = new RoutingAllocation(this.allocationDeciders, routingNodes, clusterState.nodes(), this.clusterInfoService.getClusterInfo(), this.currentNanoTime());
        allocation.debugDecision(debug);
        if (!this.reroute(allocation)) {
            return new RoutingAllocation.Result(false, clusterState.routingTable());
        }
        RoutingTable routingTable = new RoutingTable.Builder().updateNodes(routingNodes).build().validateRaiseException(clusterState.metaData());
        RoutingAllocation.Result result = new RoutingAllocation.Result(true, routingTable);
        this.logClusterHealthStateChange(new ClusterStateHealth(clusterState), new ClusterStateHealth(clusterState.getMetaData(), routingTable), reason);
        return result;
    }

    private void logClusterHealthStateChange(ClusterStateHealth previousStateHealth, ClusterStateHealth newStateHealth, String reason) {
        ClusterHealthStatus currentHealth;
        ClusterHealthStatus previousHealth = previousStateHealth.getStatus();
        if (!previousHealth.equals((Object)(currentHealth = newStateHealth.getStatus()))) {
            this.logger.info("Cluster health status changed from [{}] to [{}] (reason: [{}]).", new Object[]{previousHealth, currentHealth, reason});
        }
    }

    private boolean reroute(RoutingAllocation allocation) {
        boolean changed = false;
        changed |= this.deassociateDeadNodes(allocation);
        this.applyNewNodes(allocation);
        changed |= this.electPrimariesAndUnassignedDanglingReplicas(allocation);
        if (allocation.routingNodes().unassigned().size() > 0) {
            AllocationService.updateLeftDelayOfUnassignedShards(allocation, this.settings);
            changed |= this.shardsAllocators.allocateUnassigned(allocation);
        }
        changed |= this.shardsAllocators.moveShards(allocation);
        changed |= this.shardsAllocators.rebalance(allocation);
        assert (RoutingNodes.assertShardStats(allocation.routingNodes()));
        return changed;
    }

    public static void updateLeftDelayOfUnassignedShards(RoutingAllocation allocation, Settings settings) {
        for (ShardRouting shardRouting : allocation.routingNodes().unassigned()) {
            MetaData metaData = allocation.metaData();
            IndexMetaData indexMetaData = metaData.index(shardRouting.index());
            shardRouting.unassignedInfo().updateDelay(allocation.getCurrentNanoTime(), settings, indexMetaData.getSettings());
        }
    }

    private boolean electPrimariesAndUnassignedDanglingReplicas(RoutingAllocation allocation) {
        boolean changed = false;
        RoutingNodes routingNodes = allocation.routingNodes();
        if (routingNodes.unassigned().getNumPrimaries() == 0) {
            return changed;
        }
        ArrayList<ShardRouting> shardsToFail = new ArrayList<ShardRouting>();
        for (ShardRouting shardEntry : routingNodes.unassigned()) {
            if (!shardEntry.primary()) continue;
            for (ShardRouting routing : routingNodes.assignedShards(shardEntry)) {
                if (routing.primary() || !routing.initializing()) continue;
                shardsToFail.add(routing);
            }
        }
        for (ShardRouting shardToFail : shardsToFail) {
            changed |= this.applyFailedShard(allocation, shardToFail, false, new UnassignedInfo(UnassignedInfo.Reason.ALLOCATION_FAILED, "primary failed while replica initializing", null, allocation.getCurrentNanoTime(), System.currentTimeMillis()));
        }
        for (ShardRouting shardEntry : routingNodes.unassigned()) {
            ShardRouting candidate;
            if (!shardEntry.primary() || (candidate = allocation.routingNodes().activeReplica(shardEntry)) == null) continue;
            IndexMetaData index = allocation.metaData().index(candidate.index());
            routingNodes.swapPrimaryFlag(shardEntry, candidate);
            if (candidate.relocatingNodeId() != null) {
                changed = true;
                RoutingNode node = routingNodes.node(candidate.relocatingNodeId());
                if (node != null) {
                    for (ShardRouting shardRouting : node) {
                        if (!shardRouting.shardId().equals(candidate.shardId()) || shardRouting.primary()) continue;
                        routingNodes.swapPrimaryFlag(shardRouting);
                        break;
                    }
                }
            }
            if (!IndexMetaData.isIndexUsingShadowReplicas(index.getSettings())) continue;
            routingNodes.reinitShadowPrimary(candidate);
            changed = true;
        }
        return changed;
    }

    private void applyNewNodes(RoutingAllocation allocation) {
        RoutingNodes routingNodes = allocation.routingNodes();
        for (ObjectCursor<DiscoveryNode> objectCursor : allocation.nodes().dataNodes().values()) {
            DiscoveryNode node = (DiscoveryNode)objectCursor.value;
            if (routingNodes.isKnown(node)) continue;
            routingNodes.addNode(node);
        }
    }

    private boolean deassociateDeadNodes(RoutingAllocation allocation) {
        boolean changed = false;
        RoutingNodes.RoutingNodesIterator it = allocation.routingNodes().nodes();
        while (it.hasNext()) {
            RoutingNode node = it.next();
            if (allocation.nodes().dataNodes().containsKey(node.nodeId())) continue;
            changed = true;
            for (ShardRouting shardRouting : node.copyShards()) {
                UnassignedInfo unassignedInfo = new UnassignedInfo(UnassignedInfo.Reason.NODE_LEFT, "node_left[" + node.nodeId() + "]", null, allocation.getCurrentNanoTime(), System.currentTimeMillis());
                this.applyFailedShard(allocation, shardRouting, false, unassignedInfo);
            }
            it.remove();
        }
        return changed;
    }

    /*
     * WARNING - void declaration
     */
    private boolean applyStartedShards(RoutingNodes routingNodes, Iterable<? extends ShardRouting> startedShardEntries) {
        boolean dirty = false;
        block0: for (ShardRouting shardRouting : startedShardEntries) {
            RoutingNodes.RoutingNodeIterator sourceRoutingNode;
            void var5_5;
            assert (shardRouting.initializing());
            if (routingNodes.routingTable().index(shardRouting.index()) == null) {
                this.logger.debug("{} ignoring shard started, unknown index (routing: {})", shardRouting.shardId(), shardRouting);
                continue;
            }
            RoutingNodes.RoutingNodeIterator currentRoutingNode = routingNodes.routingNodeIter(shardRouting.currentNodeId());
            if (currentRoutingNode == null) {
                this.logger.debug("{} failed to find shard in order to start it [failed to find node], ignoring (routing: {})", shardRouting.shardId(), shardRouting);
                continue;
            }
            for (ShardRouting shard : currentRoutingNode) {
                if (!shard.isSameAllocation(shardRouting)) continue;
                if (shard.active()) {
                    this.logger.trace("{} shard is already started, ignoring (routing: {})", shardRouting.shardId(), shardRouting);
                    break;
                }
                dirty = true;
                ShardRouting shardRouting2 = new ShardRouting(shard);
                routingNodes.started(shard);
                this.logger.trace("{} marked shard as started (routing: {})", shardRouting2.shardId(), shardRouting2);
                break;
            }
            if (var5_5.relocatingNodeId() == null || (sourceRoutingNode = routingNodes.routingNodeIter(var5_5.relocatingNodeId())) == null) continue;
            while (sourceRoutingNode.hasNext()) {
                ShardRouting shard;
                shard = sourceRoutingNode.next();
                if (!shard.isRelocationSourceOf((ShardRouting)var5_5)) continue;
                dirty = true;
                sourceRoutingNode.remove();
                continue block0;
            }
        }
        return dirty;
    }

    private boolean applyFailedShard(RoutingAllocation allocation, ShardRouting failedShard, boolean addToIgnoreList, UnassignedInfo unassignedInfo) {
        IndexRoutingTable indexRoutingTable = allocation.routingTable().index(failedShard.index());
        if (indexRoutingTable == null) {
            this.logger.debug("{} ignoring shard failure, unknown index in {} ({})", failedShard.shardId(), failedShard, unassignedInfo.shortSummary());
            return false;
        }
        RoutingNodes routingNodes = allocation.routingNodes();
        RoutingNodes.RoutingNodeIterator matchedNode = routingNodes.routingNodeIter(failedShard.currentNodeId());
        if (matchedNode == null) {
            this.logger.debug("{} ignoring shard failure, unknown node in {} ({})", failedShard.shardId(), failedShard, unassignedInfo.shortSummary());
            return false;
        }
        boolean matchedShard = false;
        while (matchedNode.hasNext()) {
            ShardRouting routing = matchedNode.next();
            if (!routing.isSameAllocation(failedShard)) continue;
            matchedShard = true;
            this.logger.debug("{} failed shard {} found in routingNodes, failing it ({})", failedShard.shardId(), failedShard, unassignedInfo.shortSummary());
            break;
        }
        if (!matchedShard) {
            this.logger.debug("{} ignoring shard failure, unknown allocation id in {} ({})", failedShard.shardId(), failedShard, unassignedInfo.shortSummary());
            return false;
        }
        failedShard = new ShardRouting(matchedNode.current());
        matchedNode.remove();
        if (addToIgnoreList) {
            allocation.addIgnoreShardForNode(failedShard.shardId(), failedShard.currentNodeId());
        }
        if (failedShard.relocatingNodeId() != null && failedShard.initializing()) {
            this.logger.trace("{} is a relocation target, resolving source to cancel relocation ({})", failedShard, unassignedInfo.shortSummary());
            RoutingNode relocatingFromNode = routingNodes.node(failedShard.relocatingNodeId());
            if (relocatingFromNode != null) {
                for (ShardRouting shardRouting : relocatingFromNode) {
                    if (!shardRouting.isRelocationSourceOf(failedShard)) continue;
                    this.logger.trace("{}, resolved source to [{}]. canceling relocation ... ({})", failedShard.shardId(), shardRouting, unassignedInfo.shortSummary());
                    routingNodes.cancelRelocation(shardRouting);
                    break;
                }
            }
        } else {
            if (failedShard.relocatingNodeId() != null) {
                assert (!failedShard.initializing());
                assert (failedShard.relocating());
                RoutingNodes.RoutingNodeIterator initializingNode = routingNodes.routingNodeIter(failedShard.relocatingNodeId());
                if (initializingNode != null) {
                    while (initializingNode.hasNext()) {
                        ShardRouting shardRouting = initializingNode.next();
                        if (!shardRouting.isRelocationTargetOf(failedShard)) continue;
                        this.logger.trace("{} is removed due to the failure of the source shard", shardRouting);
                        initializingNode.remove();
                    }
                }
            }
            matchedNode.moveToUnassigned(unassignedInfo);
        }
        assert (matchedNode.isRemoved()) : "failedShard " + failedShard + " was matched but wasn't removed";
        return true;
    }

    private RoutingNodes getMutableRoutingNodes(ClusterState clusterState) {
        RoutingNodes routingNodes = new RoutingNodes(clusterState, false);
        return routingNodes;
    }

    protected long currentNanoTime() {
        return System.nanoTime();
    }
}

