/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.routing.allocation.decider;

import org.elasticsearch.cluster.routing.RestoreSource;
import org.elasticsearch.cluster.routing.RoutingNode;
import org.elasticsearch.cluster.routing.RoutingNodes;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.allocation.RoutingAllocation;
import org.elasticsearch.cluster.routing.allocation.decider.AllocationDecider;
import org.elasticsearch.cluster.routing.allocation.decider.Decision;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;

public class NodeVersionAllocationDecider
extends AllocationDecider {
    public static final String NAME = "node_version";

    @Inject
    public NodeVersionAllocationDecider(Settings settings) {
        super(settings);
    }

    @Override
    public Decision canAllocate(ShardRouting shardRouting, RoutingNode node, RoutingAllocation allocation) {
        if (shardRouting.primary()) {
            if (shardRouting.currentNodeId() == null) {
                if (shardRouting.restoreSource() != null) {
                    return this.isVersionCompatible(shardRouting.restoreSource(), node, allocation);
                }
                return allocation.decision(Decision.YES, NAME, "primary shard can be allocated anywhere", new Object[0]);
            }
            return this.isVersionCompatible(allocation.routingNodes(), shardRouting.currentNodeId(), node, allocation);
        }
        ShardRouting primary = allocation.routingNodes().activePrimary(shardRouting);
        if (primary != null) {
            return this.isVersionCompatible(allocation.routingNodes(), primary.currentNodeId(), node, allocation);
        }
        return allocation.decision(Decision.YES, NAME, "no active primary shard yet", new Object[0]);
    }

    private Decision isVersionCompatible(RoutingNodes routingNodes, String sourceNodeId, RoutingNode target, RoutingAllocation allocation) {
        RoutingNode source = routingNodes.node(sourceNodeId);
        if (target.node().version().onOrAfter(source.node().version())) {
            return allocation.decision(Decision.YES, NAME, "target node version [%s] is same or newer than source node version [%s]", target.node().version(), source.node().version());
        }
        return allocation.decision(Decision.NO, NAME, "target node version [%s] is older than source node version [%s]", target.node().version(), source.node().version());
    }

    private Decision isVersionCompatible(RestoreSource restoreSource, RoutingNode target, RoutingAllocation allocation) {
        if (target.node().version().onOrAfter(restoreSource.version())) {
            return allocation.decision(Decision.YES, NAME, "target node version [%s] is same or newer than snapshot version [%s]", target.node().version(), restoreSource.version());
        }
        return allocation.decision(Decision.NO, NAME, "target node version [%s] is older than snapshot version [%s]", target.node().version(), restoreSource.version());
    }
}

