/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.logging.jdk;

import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.elasticsearch.common.logging.support.AbstractESLogger;

public class ESLogRecord
extends LogRecord {
    private static final long serialVersionUID = 1107741560233585726L;
    private static final String FQCN = AbstractESLogger.class.getName();
    private String sourceClassName;
    private String sourceMethodName;
    private transient boolean needToInferCaller = true;

    public ESLogRecord(Level level, String msg) {
        super(level, msg);
    }

    @Override
    public String getSourceClassName() {
        if (this.needToInferCaller) {
            this.inferCaller();
        }
        return this.sourceClassName;
    }

    @Override
    public void setSourceClassName(String sourceClassName) {
        this.sourceClassName = sourceClassName;
        this.needToInferCaller = false;
    }

    @Override
    public String getSourceMethodName() {
        if (this.needToInferCaller) {
            this.inferCaller();
        }
        return this.sourceMethodName;
    }

    @Override
    public void setSourceMethodName(String sourceMethodName) {
        this.sourceMethodName = sourceMethodName;
        this.needToInferCaller = false;
    }

    private void inferCaller() {
        this.needToInferCaller = false;
        Throwable throwable = new Throwable();
        boolean lookingForLogger = true;
        for (StackTraceElement frame : throwable.getStackTrace()) {
            String cname = frame.getClassName();
            boolean isLoggerImpl = this.isLoggerImplFrame(cname);
            if (lookingForLogger) {
                if (!isLoggerImpl) continue;
                lookingForLogger = false;
                continue;
            }
            if (isLoggerImpl || cname.startsWith("java.lang.reflect.") || cname.startsWith("sun.reflect.")) continue;
            this.setSourceClassName(cname);
            this.setSourceMethodName(frame.getMethodName());
            return;
        }
    }

    private boolean isLoggerImplFrame(String cname) {
        return cname.equals(FQCN);
    }
}

