/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.discovery.zen.ping.unicast;

import com.carrotsearch.hppc.cursors.ObjectCursor;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.lucene.util.IOUtils;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.CollectionUtils;
import org.elasticsearch.common.util.concurrent.AbstractRunnable;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.common.util.concurrent.EsRejectedExecutionException;
import org.elasticsearch.discovery.zen.elect.ElectMasterService;
import org.elasticsearch.discovery.zen.ping.PingContextProvider;
import org.elasticsearch.discovery.zen.ping.ZenPing;
import org.elasticsearch.discovery.zen.ping.unicast.UnicastHostsProvider;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.BaseTransportResponseHandler;
import org.elasticsearch.transport.ConnectTransportException;
import org.elasticsearch.transport.RemoteTransportException;
import org.elasticsearch.transport.TransportChannel;
import org.elasticsearch.transport.TransportException;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportRequestHandler;
import org.elasticsearch.transport.TransportRequestOptions;
import org.elasticsearch.transport.TransportResponse;
import org.elasticsearch.transport.TransportService;

public class UnicastZenPing
extends AbstractLifecycleComponent<ZenPing>
implements ZenPing {
    public static final String ACTION_NAME = "internal:discovery/zen/unicast";
    public static final String DISCOVERY_ZEN_PING_UNICAST_HOSTS = "discovery.zen.ping.unicast.hosts";
    public static final int LIMIT_FOREIGN_PORTS_COUNT = 1;
    public static final int LIMIT_LOCAL_PORTS_COUNT = 5;
    private final ThreadPool threadPool;
    private final TransportService transportService;
    private final ClusterName clusterName;
    private final ElectMasterService electMasterService;
    private final int concurrentConnects;
    private final DiscoveryNode[] configuredTargetNodes;
    private volatile PingContextProvider contextProvider;
    private final AtomicInteger pingHandlerIdGenerator = new AtomicInteger();
    private final AtomicInteger unicastNodeIdGenerator = new AtomicInteger();
    private static final String UNICAST_NODE_PREFIX = "#zen_unicast_";
    private final Map<Integer, SendPingsHandler> receivedResponses = ConcurrentCollections.newConcurrentMap();
    private final Queue<ZenPing.PingResponse> temporalResponses = ConcurrentCollections.newQueue();
    private final CopyOnWriteArrayList<UnicastHostsProvider> hostsProviders = new CopyOnWriteArrayList();
    private final ExecutorService unicastConnectExecutor;
    private volatile boolean closed = false;

    @Inject
    public UnicastZenPing(Settings settings, ThreadPool threadPool, TransportService transportService, ClusterName clusterName, Version version, ElectMasterService electMasterService, @Nullable Set<UnicastHostsProvider> unicastHostsProviders) {
        super(settings);
        int limitPortCounts;
        this.threadPool = threadPool;
        this.transportService = transportService;
        this.clusterName = clusterName;
        this.electMasterService = electMasterService;
        if (unicastHostsProviders != null) {
            for (UnicastHostsProvider unicastHostsProvider : unicastHostsProviders) {
                this.addHostsProvider(unicastHostsProvider);
            }
        }
        this.concurrentConnects = this.settings.getAsInt("discovery.zen.ping.unicast.concurrent_connects", (Integer)10);
        String[] hostArr = this.settings.getAsArray(DISCOVERY_ZEN_PING_UNICAST_HOSTS);
        for (int i = 0; i < hostArr.length; ++i) {
            hostArr[i] = hostArr[i].trim();
        }
        ArrayList<String> hosts = CollectionUtils.arrayAsArrayList(hostArr);
        if (hosts.isEmpty()) {
            limitPortCounts = 5;
            hosts.addAll(transportService.getLocalAddresses());
        } else {
            limitPortCounts = 1;
        }
        this.logger.debug("using initial hosts {}, with concurrent_connects [{}]", hosts, this.concurrentConnects);
        ArrayList<DiscoveryNode> configuredTargetNodes = new ArrayList<DiscoveryNode>();
        for (String host : hosts) {
            try {
                TransportAddress[] addresses;
                for (TransportAddress address : addresses = transportService.addressesFromString(host, limitPortCounts)) {
                    configuredTargetNodes.add(new DiscoveryNode(UNICAST_NODE_PREFIX + this.unicastNodeIdGenerator.incrementAndGet() + "#", address, version.minimumCompatibilityVersion()));
                }
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Failed to resolve address for [" + host + "]", e);
            }
        }
        this.configuredTargetNodes = configuredTargetNodes.toArray(new DiscoveryNode[configuredTargetNodes.size()]);
        transportService.registerRequestHandler(ACTION_NAME, UnicastPingRequest.class, "same", new UnicastPingRequestHandler());
        ThreadFactory threadFactory = EsExecutors.daemonThreadFactory(settings, "[unicast_connect]");
        this.unicastConnectExecutor = EsExecutors.newScaling("unicast_connect", 0, this.concurrentConnects, 60L, TimeUnit.SECONDS, threadFactory);
    }

    @Override
    protected void doStart() {
    }

    @Override
    protected void doStop() {
    }

    @Override
    protected void doClose() {
        this.transportService.removeHandler(ACTION_NAME);
        ThreadPool.terminate(this.unicastConnectExecutor, 0L, TimeUnit.SECONDS);
        try {
            IOUtils.close(this.receivedResponses.values());
        }
        catch (IOException e) {
            throw new ElasticsearchException("Error wile closing send ping handlers", (Throwable)e, new Object[0]);
        }
        this.closed = true;
    }

    public void addHostsProvider(UnicastHostsProvider provider) {
        this.hostsProviders.add(provider);
    }

    public void removeHostsProvider(UnicastHostsProvider provider) {
        this.hostsProviders.remove(provider);
    }

    @Override
    public void setPingContextProvider(PingContextProvider contextProvider) {
        this.contextProvider = contextProvider;
    }

    public void clearTemporalResponses() {
        this.temporalResponses.clear();
    }

    public ZenPing.PingResponse[] pingAndWait(TimeValue timeout) {
        final AtomicReference response = new AtomicReference();
        final CountDownLatch latch = new CountDownLatch(1);
        this.ping(new ZenPing.PingListener(){

            @Override
            public void onPing(ZenPing.PingResponse[] pings) {
                response.set(pings);
                latch.countDown();
            }
        }, timeout);
        try {
            latch.await();
            return (ZenPing.PingResponse[])response.get();
        }
        catch (InterruptedException e) {
            return null;
        }
    }

    @Override
    public void ping(final ZenPing.PingListener listener, final TimeValue timeout) {
        final SendPingsHandler sendPingsHandler = new SendPingsHandler(this.pingHandlerIdGenerator.incrementAndGet());
        try {
            this.receivedResponses.put(sendPingsHandler.id(), sendPingsHandler);
            try {
                this.sendPings(timeout, null, sendPingsHandler);
            }
            catch (RejectedExecutionException e) {
                this.logger.debug("Ping execution rejected", e, new Object[0]);
            }
            this.threadPool.schedule(TimeValue.timeValueMillis(timeout.millis() / 2L), "generic", new AbstractRunnable(){

                @Override
                protected void doRun() {
                    UnicastZenPing.this.sendPings(timeout, null, sendPingsHandler);
                    UnicastZenPing.this.threadPool.schedule(TimeValue.timeValueMillis(timeout.millis() / 2L), "generic", new AbstractRunnable(){

                        @Override
                        protected void doRun() throws Exception {
                            UnicastZenPing.this.sendPings(timeout, TimeValue.timeValueMillis(timeout.millis() / 2L), sendPingsHandler);
                            sendPingsHandler.close();
                            listener.onPing(sendPingsHandler.pingCollection().toArray());
                            for (DiscoveryNode node : sendPingsHandler.nodeToDisconnect) {
                                UnicastZenPing.this.logger.trace("[{}] disconnecting from {}", sendPingsHandler.id(), node);
                                UnicastZenPing.this.transportService.disconnectFromNode(node);
                            }
                        }

                        @Override
                        public void onFailure(Throwable t) {
                            UnicastZenPing.this.logger.debug("Ping execution failed", t, new Object[0]);
                            sendPingsHandler.close();
                        }
                    });
                }

                @Override
                public void onFailure(Throwable t) {
                    UnicastZenPing.this.logger.debug("Ping execution failed", t, new Object[0]);
                    sendPingsHandler.close();
                }
            });
        }
        catch (EsRejectedExecutionException ex) {
            sendPingsHandler.close();
        }
        catch (Exception e) {
            sendPingsHandler.close();
            throw new ElasticsearchException("Ping execution failed", (Throwable)e, new Object[0]);
        }
    }

    void sendPings(final TimeValue timeout, @Nullable TimeValue waitTime, final SendPingsHandler sendPingsHandler) {
        final UnicastPingRequest pingRequest = new UnicastPingRequest();
        pingRequest.id = sendPingsHandler.id();
        pingRequest.timeout = timeout;
        DiscoveryNodes discoNodes = this.contextProvider.nodes();
        pingRequest.pingResponse = this.createPingResponse(discoNodes);
        HashSet<DiscoveryNode> nodesToPingSet = new HashSet<DiscoveryNode>();
        for (ZenPing.PingResponse pingResponse : this.temporalResponses) {
            if (!this.clusterName.equals(pingResponse.clusterName())) continue;
            nodesToPingSet.add(pingResponse.node());
        }
        for (UnicastHostsProvider unicastHostsProvider : this.hostsProviders) {
            nodesToPingSet.addAll(unicastHostsProvider.buildDynamicNodes());
        }
        for (ObjectCursor objectCursor : discoNodes.getMasterNodes().values()) {
            nodesToPingSet.add((DiscoveryNode)objectCursor.value);
        }
        List<DiscoveryNode> sortedNodesToPing = this.electMasterService.sortByMasterLikelihood(nodesToPingSet);
        ArrayList<DiscoveryNode> arrayList = CollectionUtils.arrayAsArrayList(this.configuredTargetNodes);
        arrayList.addAll(sortedNodesToPing);
        final CountDownLatch latch = new CountDownLatch(arrayList.size());
        for (final DiscoveryNode node : arrayList) {
            boolean nodeFoundByAddress;
            DiscoveryNode nodeToSend = discoNodes.findByAddress(node.address());
            if (nodeToSend != null) {
                nodeFoundByAddress = true;
            } else {
                nodeToSend = node;
                nodeFoundByAddress = false;
            }
            if (!this.transportService.nodeConnected(nodeToSend)) {
                if (sendPingsHandler.isClosed()) {
                    return;
                }
                if (!nodeFoundByAddress) {
                    if (!nodeToSend.id().startsWith(UNICAST_NODE_PREFIX)) {
                        DiscoveryNode tempNode = new DiscoveryNode("", UNICAST_NODE_PREFIX + this.unicastNodeIdGenerator.incrementAndGet() + "_" + nodeToSend.id() + "#", nodeToSend.getHostName(), nodeToSend.getHostAddress(), nodeToSend.address(), (Map<String, String>)nodeToSend.attributes(), nodeToSend.version());
                        this.logger.trace("replacing {} with temp node {}", nodeToSend, tempNode);
                        nodeToSend = tempNode;
                    }
                    sendPingsHandler.nodeToDisconnect.add(nodeToSend);
                }
                final DiscoveryNode finalNodeToSend = nodeToSend;
                this.unicastConnectExecutor.execute(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        if (sendPingsHandler.isClosed()) {
                            return;
                        }
                        boolean success = false;
                        try {
                            if (!nodeFoundByAddress) {
                                UnicastZenPing.this.logger.trace("[{}] connecting (light) to {}", sendPingsHandler.id(), finalNodeToSend);
                                UnicastZenPing.this.transportService.connectToNodeLight(finalNodeToSend);
                            } else {
                                UnicastZenPing.this.logger.trace("[{}] connecting to {}", sendPingsHandler.id(), finalNodeToSend);
                                UnicastZenPing.this.transportService.connectToNode(finalNodeToSend);
                            }
                            UnicastZenPing.this.logger.trace("[{}] connected to {}", sendPingsHandler.id(), node);
                            if (UnicastZenPing.this.receivedResponses.containsKey(sendPingsHandler.id())) {
                                UnicastZenPing.this.sendPingRequestToNode(sendPingsHandler.id(), timeout, pingRequest, latch, node, finalNodeToSend);
                            } else {
                                latch.countDown();
                                UnicastZenPing.this.logger.trace("[{}] connect to {} was too long outside of ping window, bailing", sendPingsHandler.id(), node);
                            }
                            success = true;
                        }
                        catch (ConnectTransportException e) {
                            UnicastZenPing.this.logger.trace("[{}] failed to connect to {}", e, sendPingsHandler.id(), finalNodeToSend);
                        }
                        catch (RemoteTransportException e) {
                            UnicastZenPing.this.logger.debug("[{}] received a remote error as a response to ping {}", e, sendPingsHandler.id(), finalNodeToSend);
                        }
                        catch (Throwable e) {
                            UnicastZenPing.this.logger.warn("[{}] failed send ping to {}", e, sendPingsHandler.id(), finalNodeToSend);
                        }
                        finally {
                            if (!success) {
                                latch.countDown();
                            }
                        }
                    }
                });
                continue;
            }
            this.sendPingRequestToNode(sendPingsHandler.id(), timeout, pingRequest, latch, node, nodeToSend);
        }
        if (waitTime != null) {
            try {
                latch.await(waitTime.millis(), TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private void sendPingRequestToNode(final int id, TimeValue timeout, UnicastPingRequest pingRequest, final CountDownLatch latch, final DiscoveryNode node, final DiscoveryNode nodeToSend) {
        this.logger.trace("[{}] sending to {}", id, nodeToSend);
        this.transportService.sendRequest(nodeToSend, ACTION_NAME, pingRequest, TransportRequestOptions.builder().withTimeout((long)((double)timeout.millis() * 1.25)).build(), new BaseTransportResponseHandler<UnicastPingResponse>(){

            @Override
            public UnicastPingResponse newInstance() {
                return new UnicastPingResponse();
            }

            @Override
            public String executor() {
                return "same";
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void handleResponse(UnicastPingResponse response) {
                UnicastZenPing.this.logger.trace("[{}] received response from {}: {}", id, nodeToSend, Arrays.toString(response.pingResponses));
                try {
                    DiscoveryNodes discoveryNodes = UnicastZenPing.this.contextProvider.nodes();
                    for (ZenPing.PingResponse pingResponse : response.pingResponses) {
                        if (pingResponse.node().id().equals(discoveryNodes.localNodeId())) continue;
                        if (!pingResponse.clusterName().equals(UnicastZenPing.this.clusterName)) {
                            UnicastZenPing.this.logger.debug("[{}] filtering out response from {}, not same cluster_name [{}]", id, pingResponse.node(), pingResponse.clusterName().value());
                            continue;
                        }
                        SendPingsHandler sendPingsHandler = (SendPingsHandler)UnicastZenPing.this.receivedResponses.get(response.id);
                        if (sendPingsHandler == null) {
                            if (UnicastZenPing.this.closed) continue;
                            UnicastZenPing.this.logger.warn("received ping response {} with no matching handler id [{}]", pingResponse, response.id);
                            continue;
                        }
                        sendPingsHandler.pingCollection().addPing(pingResponse);
                    }
                }
                finally {
                    latch.countDown();
                }
            }

            @Override
            public void handleException(TransportException exp) {
                latch.countDown();
                if (exp instanceof ConnectTransportException) {
                    UnicastZenPing.this.logger.trace("failed to connect to {}", exp, nodeToSend);
                } else {
                    UnicastZenPing.this.logger.warn("failed to send ping to [{}]", exp, node);
                }
            }
        });
    }

    private UnicastPingResponse handlePingRequest(final UnicastPingRequest request) {
        if (!this.lifecycle.started()) {
            throw new IllegalStateException("received ping request while not started");
        }
        this.temporalResponses.add(request.pingResponse);
        this.threadPool.schedule(TimeValue.timeValueMillis(request.timeout.millis() * 2L), "same", new Runnable(){

            @Override
            public void run() {
                UnicastZenPing.this.temporalResponses.remove(request.pingResponse);
            }
        });
        ArrayList<ZenPing.PingResponse> pingResponses = CollectionUtils.iterableAsArrayList(this.temporalResponses);
        pingResponses.add(this.createPingResponse(this.contextProvider.nodes()));
        UnicastPingResponse unicastPingResponse = new UnicastPingResponse();
        unicastPingResponse.id = request.id;
        unicastPingResponse.pingResponses = pingResponses.toArray(new ZenPing.PingResponse[pingResponses.size()]);
        return unicastPingResponse;
    }

    private ZenPing.PingResponse createPingResponse(DiscoveryNodes discoNodes) {
        return new ZenPing.PingResponse(discoNodes.localNode(), discoNodes.masterNode(), this.clusterName, this.contextProvider.nodeHasJoinedClusterOnce());
    }

    static class UnicastPingResponse
    extends TransportResponse {
        int id;
        ZenPing.PingResponse[] pingResponses;

        UnicastPingResponse() {
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.id = in.readInt();
            this.pingResponses = new ZenPing.PingResponse[in.readVInt()];
            for (int i = 0; i < this.pingResponses.length; ++i) {
                this.pingResponses[i] = ZenPing.PingResponse.readPingResponse(in);
            }
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeInt(this.id);
            out.writeVInt(this.pingResponses.length);
            for (ZenPing.PingResponse pingResponse : this.pingResponses) {
                pingResponse.writeTo(out);
            }
        }
    }

    public static class UnicastPingRequest
    extends TransportRequest {
        int id;
        TimeValue timeout;
        ZenPing.PingResponse pingResponse;

        @Override
        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.id = in.readInt();
            this.timeout = TimeValue.readTimeValue(in);
            this.pingResponse = ZenPing.PingResponse.readPingResponse(in);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeInt(this.id);
            this.timeout.writeTo(out);
            this.pingResponse.writeTo(out);
        }
    }

    class UnicastPingRequestHandler
    extends TransportRequestHandler<UnicastPingRequest> {
        UnicastPingRequestHandler() {
        }

        @Override
        public void messageReceived(UnicastPingRequest request, TransportChannel channel) throws Exception {
            channel.sendResponse(UnicastZenPing.this.handlePingRequest(request));
        }
    }

    class SendPingsHandler
    implements Closeable {
        private final int id;
        private final Set<DiscoveryNode> nodeToDisconnect = ConcurrentCollections.newConcurrentSet();
        private final ZenPing.PingCollection pingCollection;
        private AtomicBoolean closed = new AtomicBoolean(false);

        SendPingsHandler(int id) {
            this.id = id;
            this.pingCollection = new ZenPing.PingCollection();
        }

        public int id() {
            return this.id;
        }

        public boolean isClosed() {
            return this.closed.get();
        }

        public ZenPing.PingCollection pingCollection() {
            return this.pingCollection;
        }

        @Override
        public void close() {
            if (this.closed.compareAndSet(false, true)) {
                UnicastZenPing.this.receivedResponses.remove(this.id);
            }
        }
    }
}

