/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.gateway;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.apache.lucene.util.CollectionUtil;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.routing.RoutingNode;
import org.elasticsearch.cluster.routing.RoutingNodes;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.allocation.RoutingAllocation;
import org.elasticsearch.cluster.routing.allocation.decider.Decision;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.gateway.AsyncShardFetch;
import org.elasticsearch.gateway.TransportNodesListGatewayStartedShards;

public abstract class PrimaryShardAllocator
extends AbstractComponent {
    public static final String INDEX_RECOVERY_INITIAL_SHARDS = "index.recovery.initial_shards";
    private final String initialShards;

    public PrimaryShardAllocator(Settings settings) {
        super(settings);
        this.initialShards = settings.get("gateway.initial_shards", settings.get("gateway.local.initial_shards", "quorum"));
        this.logger.debug("using initial_shards [{}]", this.initialShards);
    }

    public boolean allocateUnassigned(RoutingAllocation allocation) {
        boolean changed = false;
        RoutingNodes routingNodes = allocation.routingNodes();
        MetaData metaData = routingNodes.metaData();
        RoutingNodes.UnassignedShards.UnassignedIterator unassignedIterator = routingNodes.unassigned().iterator();
        while (unassignedIterator.hasNext()) {
            DiscoveryNode node;
            ShardRouting shard = unassignedIterator.next();
            if (!this.needToFindPrimaryCopy(shard)) continue;
            AsyncShardFetch.FetchResult<TransportNodesListGatewayStartedShards.NodeGatewayStartedShards> shardState = this.fetchData(shard, allocation);
            if (!shardState.hasData()) {
                this.logger.trace("{}: ignoring allocation, still fetching shard started state", shard);
                allocation.setHasPendingAsyncFetch();
                unassignedIterator.removeAndIgnore();
                continue;
            }
            IndexMetaData indexMetaData = metaData.index(shard.getIndex());
            NodesAndVersions nodesAndVersions = this.buildNodesAndVersions(shard, this.recoverOnAnyNode(indexMetaData.getSettings()), allocation.getIgnoreNodes(shard.shardId()), shardState);
            this.logger.debug("[{}][{}] found {} allocations of {}, highest version: [{}]", shard.index(), shard.id(), nodesAndVersions.allocationsFound, shard, nodesAndVersions.highestVersion);
            if (!this.isEnoughAllocationsFound(shard, indexMetaData, nodesAndVersions)) {
                if (shard.restoreSource() == null) {
                    unassignedIterator.removeAndIgnore();
                    this.logger.debug("[{}][{}]: not allocating, number_of_allocated_shards_found [{}]", shard.index(), shard.id(), nodesAndVersions.allocationsFound);
                    continue;
                }
                this.logger.debug("[{}][{}]: missing local data, will restore from [{}]", shard.index(), shard.id(), shard.restoreSource());
                continue;
            }
            NodesToAllocate nodesToAllocate = this.buildNodesToAllocate(shard, allocation, nodesAndVersions);
            if (!nodesToAllocate.yesNodes.isEmpty()) {
                node = nodesToAllocate.yesNodes.get(0);
                this.logger.debug("[{}][{}]: allocating [{}] to [{}] on primary allocation", shard.index(), shard.id(), shard, node);
                changed = true;
                unassignedIterator.initialize(node.id(), nodesAndVersions.highestVersion, -1L);
                continue;
            }
            if (nodesToAllocate.throttleNodes.isEmpty() && !nodesToAllocate.noNodes.isEmpty()) {
                node = nodesToAllocate.noNodes.get(0);
                this.logger.debug("[{}][{}]: forcing allocating [{}] to [{}] on primary allocation", shard.index(), shard.id(), shard, node);
                changed = true;
                unassignedIterator.initialize(node.id(), nodesAndVersions.highestVersion, -1L);
                continue;
            }
            this.logger.debug("[{}][{}]: throttling allocation [{}] to [{}] on primary allocation", shard.index(), shard.id(), shard, nodesToAllocate.throttleNodes);
            unassignedIterator.removeAndIgnore();
        }
        return changed;
    }

    boolean needToFindPrimaryCopy(ShardRouting shard) {
        if (!shard.primary()) {
            return false;
        }
        return shard.allocatedPostIndexCreate();
    }

    private boolean isEnoughAllocationsFound(ShardRouting shard, IndexMetaData indexMetaData, NodesAndVersions nodesAndVersions) {
        int requiredAllocation = 1;
        if (shard.restoreSource() == null) {
            try {
                String initialShards = indexMetaData.getSettings().get(INDEX_RECOVERY_INITIAL_SHARDS, this.settings.get(INDEX_RECOVERY_INITIAL_SHARDS, this.initialShards));
                if ("quorum".equals(initialShards)) {
                    if (indexMetaData.getNumberOfReplicas() > 1) {
                        requiredAllocation = (1 + indexMetaData.getNumberOfReplicas()) / 2 + 1;
                    }
                } else if ("quorum-1".equals(initialShards) || "half".equals(initialShards)) {
                    if (indexMetaData.getNumberOfReplicas() > 2) {
                        requiredAllocation = (1 + indexMetaData.getNumberOfReplicas()) / 2;
                    }
                } else if ("one".equals(initialShards)) {
                    requiredAllocation = 1;
                } else if ("full".equals(initialShards) || "all".equals(initialShards)) {
                    requiredAllocation = indexMetaData.getNumberOfReplicas() + 1;
                } else if ("full-1".equals(initialShards) || "all-1".equals(initialShards)) {
                    if (indexMetaData.getNumberOfReplicas() > 1) {
                        requiredAllocation = indexMetaData.getNumberOfReplicas();
                    }
                } else {
                    requiredAllocation = Integer.parseInt(initialShards);
                }
            }
            catch (Exception e) {
                this.logger.warn("[{}][{}] failed to derived initial_shards from value {}, ignore allocation for {}", shard.index(), shard.id(), this.initialShards, shard);
            }
        }
        return nodesAndVersions.allocationsFound >= requiredAllocation;
    }

    private NodesToAllocate buildNodesToAllocate(ShardRouting shard, RoutingAllocation allocation, NodesAndVersions nodesAndVersions) {
        ArrayList<DiscoveryNode> yesNodes = new ArrayList<DiscoveryNode>();
        ArrayList<DiscoveryNode> throttledNodes = new ArrayList<DiscoveryNode>();
        ArrayList<DiscoveryNode> noNodes = new ArrayList<DiscoveryNode>();
        for (DiscoveryNode discoNode : nodesAndVersions.nodes) {
            RoutingNode node = allocation.routingNodes().node(discoNode.id());
            if (node == null) continue;
            Decision decision = allocation.deciders().canAllocate(shard, node, allocation);
            if (decision.type() == Decision.Type.THROTTLE) {
                throttledNodes.add(discoNode);
                continue;
            }
            if (decision.type() == Decision.Type.NO) {
                noNodes.add(discoNode);
                continue;
            }
            yesNodes.add(discoNode);
        }
        return new NodesToAllocate(Collections.unmodifiableList(yesNodes), Collections.unmodifiableList(throttledNodes), Collections.unmodifiableList(noNodes));
    }

    NodesAndVersions buildNodesAndVersions(ShardRouting shard, boolean recoveryOnAnyNode, Set<String> ignoreNodes, AsyncShardFetch.FetchResult<TransportNodesListGatewayStartedShards.NodeGatewayStartedShards> shardState) {
        final HashMap nodesWithVersion = Maps.newHashMap();
        int numberOfAllocationsFound = 0;
        long highestVersion = -1L;
        for (TransportNodesListGatewayStartedShards.NodeGatewayStartedShards nodeShardState : shardState.getData().values()) {
            long version = nodeShardState.version();
            DiscoveryNode node = nodeShardState.getNode();
            if (ignoreNodes.contains(node.id())) continue;
            if (nodeShardState.storeException() == null) {
                this.logger.trace("[{}] on node [{}] has version [{}] of shard", shard, nodeShardState.getNode(), version);
            } else {
                this.logger.trace("[{}] on node [{}] has version [{}] but the store can not be opened, treating as version -1", nodeShardState.storeException(), shard, nodeShardState.getNode(), version);
                version = -1L;
            }
            if (recoveryOnAnyNode) {
                ++numberOfAllocationsFound;
                if (version > highestVersion) {
                    highestVersion = version;
                }
                nodesWithVersion.put(node, version);
                continue;
            }
            if (version == -1L) continue;
            ++numberOfAllocationsFound;
            if (version > highestVersion) {
                highestVersion = version;
                nodesWithVersion.clear();
                nodesWithVersion.put(node, version);
                continue;
            }
            if (version != highestVersion) continue;
            nodesWithVersion.put(node, version);
        }
        ArrayList nodesWithHighestVersion = new ArrayList();
        nodesWithHighestVersion.addAll(nodesWithVersion.keySet());
        CollectionUtil.timSort(nodesWithHighestVersion, new Comparator<DiscoveryNode>(){

            @Override
            public int compare(DiscoveryNode o1, DiscoveryNode o2) {
                return Long.compare((Long)nodesWithVersion.get(o2), (Long)nodesWithVersion.get(o1));
            }
        });
        if (this.logger.isTraceEnabled()) {
            StringBuilder sb = new StringBuilder("[");
            for (DiscoveryNode n : nodesWithVersion.keySet()) {
                sb.append("[").append(n.getName()).append("]").append(" -> ").append(nodesWithVersion.get(n)).append(", ");
            }
            sb.append("]");
            this.logger.trace("{} candidates for allocation: {}", shard, sb.toString());
        }
        return new NodesAndVersions(Collections.unmodifiableList(nodesWithHighestVersion), numberOfAllocationsFound, highestVersion);
    }

    private boolean recoverOnAnyNode(Settings idxSettings) {
        return IndexMetaData.isOnSharedFilesystem(idxSettings) && idxSettings.getAsBoolean("index.shared_filesystem.recover_on_any_node", (Boolean)false) != false;
    }

    protected abstract AsyncShardFetch.FetchResult<TransportNodesListGatewayStartedShards.NodeGatewayStartedShards> fetchData(ShardRouting var1, RoutingAllocation var2);

    static class NodesToAllocate {
        final List<DiscoveryNode> yesNodes;
        final List<DiscoveryNode> throttleNodes;
        final List<DiscoveryNode> noNodes;

        public NodesToAllocate(List<DiscoveryNode> yesNodes, List<DiscoveryNode> throttleNodes, List<DiscoveryNode> noNodes) {
            this.yesNodes = yesNodes;
            this.throttleNodes = throttleNodes;
            this.noNodes = noNodes;
        }
    }

    static class NodesAndVersions {
        public final List<DiscoveryNode> nodes;
        public final int allocationsFound;
        public final long highestVersion;

        public NodesAndVersions(List<DiscoveryNode> nodes, int allocationsFound, long highestVersion) {
            this.nodes = nodes;
            this.allocationsFound = allocationsFound;
            this.highestVersion = highestVersion;
        }
    }
}

