/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata;

import com.carrotsearch.hppc.ObjectLongHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.apache.lucene.util.Accountable;
import org.elasticsearch.common.metrics.CounterMetric;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.elasticsearch.index.fielddata.FieldDataStats;
import org.elasticsearch.index.fielddata.FieldDataType;
import org.elasticsearch.index.fielddata.IndexFieldDataCache;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.shard.ShardId;

public class ShardFieldData
implements IndexFieldDataCache.Listener {
    final CounterMetric evictionsMetric = new CounterMetric();
    final CounterMetric totalMetric = new CounterMetric();
    final ConcurrentMap<String, CounterMetric> perFieldTotals = ConcurrentCollections.newConcurrentMap();

    public FieldDataStats stats(String ... fields) {
        ObjectLongHashMap<String> fieldTotals = null;
        if (fields != null && fields.length > 0) {
            fieldTotals = new ObjectLongHashMap<String>();
            for (Map.Entry entry : this.perFieldTotals.entrySet()) {
                if (!Regex.simpleMatch(fields, (String)entry.getKey())) continue;
                fieldTotals.put((String)entry.getKey(), ((CounterMetric)entry.getValue()).count());
            }
        }
        return new FieldDataStats(this.totalMetric.count(), this.evictionsMetric.count(), fieldTotals);
    }

    @Override
    public void onCache(ShardId shardId, MappedFieldType.Names fieldNames, FieldDataType fieldDataType, Accountable ramUsage) {
        this.totalMetric.inc(ramUsage.ramBytesUsed());
        String keyFieldName = fieldNames.indexName();
        CounterMetric total = (CounterMetric)this.perFieldTotals.get(keyFieldName);
        if (total != null) {
            total.inc(ramUsage.ramBytesUsed());
        } else {
            total = new CounterMetric();
            total.inc(ramUsage.ramBytesUsed());
            CounterMetric prev = this.perFieldTotals.putIfAbsent(keyFieldName, total);
            if (prev != null) {
                prev.inc(ramUsage.ramBytesUsed());
            }
        }
    }

    @Override
    public void onRemoval(ShardId shardId, MappedFieldType.Names fieldNames, FieldDataType fieldDataType, boolean wasEvicted, long sizeInBytes) {
        if (wasEvicted) {
            this.evictionsMetric.inc();
        }
        if (sizeInBytes != -1L) {
            this.totalMetric.dec(sizeInBytes);
            String keyFieldName = fieldNames.indexName();
            CounterMetric total = (CounterMetric)this.perFieldTotals.get(keyFieldName);
            if (total != null) {
                total.dec(sizeInBytes);
            }
        }
    }
}

