/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata.fieldcomparator;

import java.io.IOException;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.FieldComparator;
import org.apache.lucene.search.SortField;
import org.apache.lucene.util.BitSet;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.index.fielddata.AtomicNumericFieldData;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.IndexNumericFieldData;
import org.elasticsearch.index.fielddata.NumericDoubleValues;
import org.elasticsearch.index.fielddata.SortedNumericDoubleValues;
import org.elasticsearch.search.MultiValueMode;

public class FloatValuesComparatorSource
extends IndexFieldData.XFieldComparatorSource {
    private final IndexNumericFieldData indexFieldData;
    private final Object missingValue;
    private final MultiValueMode sortMode;
    private final IndexFieldData.XFieldComparatorSource.Nested nested;

    public FloatValuesComparatorSource(IndexNumericFieldData indexFieldData, @Nullable Object missingValue, MultiValueMode sortMode, IndexFieldData.XFieldComparatorSource.Nested nested) {
        this.indexFieldData = indexFieldData;
        this.missingValue = missingValue;
        this.sortMode = sortMode;
        this.nested = nested;
    }

    @Override
    public SortField.Type reducedType() {
        return SortField.Type.FLOAT;
    }

    @Override
    public FieldComparator<?> newComparator(String fieldname, int numHits, int sortPos, boolean reversed) throws IOException {
        assert (this.indexFieldData == null || fieldname.equals(this.indexFieldData.getFieldNames().indexName()));
        final float dMissingValue = ((Float)this.missingObject(this.missingValue, reversed)).floatValue();
        return new FieldComparator.FloatComparator(numHits, null, null){

            @Override
            protected NumericDocValues getNumericDocValues(LeafReaderContext context, String field) throws IOException {
                NumericDoubleValues selectedValues;
                SortedNumericDoubleValues values = ((AtomicNumericFieldData)FloatValuesComparatorSource.this.indexFieldData.load(context)).getDoubleValues();
                if (FloatValuesComparatorSource.this.nested == null) {
                    selectedValues = FloatValuesComparatorSource.this.sortMode.select(values, (double)dMissingValue);
                } else {
                    BitSet rootDocs = FloatValuesComparatorSource.this.nested.rootDocs(context);
                    DocIdSetIterator innerDocs = FloatValuesComparatorSource.this.nested.innerDocs(context);
                    selectedValues = FloatValuesComparatorSource.this.sortMode.select(values, dMissingValue, rootDocs, innerDocs, context.reader().maxDoc());
                }
                return selectedValues.getRawFloatValues();
            }
        };
    }
}

