/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata.plain;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.store.ByteArrayDataInput;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.util.ByteUtils;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.fielddata.AtomicNumericFieldData;
import org.elasticsearch.index.fielddata.FieldDataType;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.IndexNumericFieldData;
import org.elasticsearch.index.fielddata.SortedNumericDoubleValues;
import org.elasticsearch.index.fielddata.fieldcomparator.DoubleValuesComparatorSource;
import org.elasticsearch.index.fielddata.fieldcomparator.FloatValuesComparatorSource;
import org.elasticsearch.index.fielddata.fieldcomparator.LongValuesComparatorSource;
import org.elasticsearch.index.fielddata.plain.AtomicDoubleFieldData;
import org.elasticsearch.index.fielddata.plain.AtomicLongFieldData;
import org.elasticsearch.index.fielddata.plain.DocValuesIndexFieldData;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.search.MultiValueMode;

public class BinaryDVNumericIndexFieldData
extends DocValuesIndexFieldData
implements IndexNumericFieldData {
    private final IndexNumericFieldData.NumericType numericType;

    public BinaryDVNumericIndexFieldData(Index index, MappedFieldType.Names fieldNames, IndexNumericFieldData.NumericType numericType, FieldDataType fieldDataType) {
        super(index, fieldNames, fieldDataType);
        Preconditions.checkArgument((numericType != null ? 1 : 0) != 0, (Object)"numericType must be non-null");
        this.numericType = numericType;
    }

    @Override
    public IndexFieldData.XFieldComparatorSource comparatorSource(Object missingValue, MultiValueMode sortMode, IndexFieldData.XFieldComparatorSource.Nested nested) {
        switch (this.numericType) {
            case FLOAT: {
                return new FloatValuesComparatorSource(this, missingValue, sortMode, nested);
            }
            case DOUBLE: {
                return new DoubleValuesComparatorSource(this, missingValue, sortMode, nested);
            }
        }
        assert (!this.numericType.isFloatingPoint());
        return new LongValuesComparatorSource(this, missingValue, sortMode, nested);
    }

    @Override
    public AtomicNumericFieldData load(LeafReaderContext context) {
        try {
            final BinaryDocValues values = DocValues.getBinary(context.reader(), this.fieldNames.indexName());
            if (this.numericType.isFloatingPoint()) {
                return new AtomicDoubleFieldData(-1L){

                    @Override
                    public SortedNumericDoubleValues getDoubleValues() {
                        switch (BinaryDVNumericIndexFieldData.this.numericType) {
                            case FLOAT: {
                                return new BinaryAsSortedNumericFloatValues(values);
                            }
                            case DOUBLE: {
                                return new BinaryAsSortedNumericDoubleValues(values);
                            }
                        }
                        throw new IllegalArgumentException("" + (Object)((Object)BinaryDVNumericIndexFieldData.this.numericType));
                    }

                    @Override
                    public Collection<Accountable> getChildResources() {
                        return Collections.emptyList();
                    }
                };
            }
            return new AtomicLongFieldData(0L){

                @Override
                public SortedNumericDocValues getLongValues() {
                    return new BinaryAsSortedNumericDocValues(values);
                }

                @Override
                public Collection<Accountable> getChildResources() {
                    return Collections.emptyList();
                }
            };
        }
        catch (IOException e) {
            throw new IllegalStateException("Cannot load doc values", e);
        }
    }

    @Override
    public AtomicNumericFieldData loadDirect(LeafReaderContext context) throws Exception {
        return this.load(context);
    }

    @Override
    public IndexNumericFieldData.NumericType getNumericType() {
        return this.numericType;
    }

    private static class BinaryAsSortedNumericFloatValues
    extends SortedNumericDoubleValues {
        private final BinaryDocValues values;
        private BytesRef bytes;
        private int valueCount = 0;

        BinaryAsSortedNumericFloatValues(BinaryDocValues values) {
            this.values = values;
        }

        @Override
        public void setDocument(int docId) {
            this.bytes = this.values.get(docId);
            assert (this.bytes.length % 4 == 0);
            this.valueCount = this.bytes.length / 4;
        }

        @Override
        public int count() {
            return this.valueCount;
        }

        @Override
        public double valueAt(int index) {
            return ByteUtils.readFloatLE(this.bytes.bytes, this.bytes.offset + index * 4);
        }
    }

    private static class BinaryAsSortedNumericDoubleValues
    extends SortedNumericDoubleValues {
        private final BinaryDocValues values;
        private BytesRef bytes;
        private int valueCount = 0;

        BinaryAsSortedNumericDoubleValues(BinaryDocValues values) {
            this.values = values;
        }

        @Override
        public void setDocument(int docId) {
            this.bytes = this.values.get(docId);
            assert (this.bytes.length % 8 == 0);
            this.valueCount = this.bytes.length / 8;
        }

        @Override
        public int count() {
            return this.valueCount;
        }

        @Override
        public double valueAt(int index) {
            return ByteUtils.readDoubleLE(this.bytes.bytes, this.bytes.offset + index * 8);
        }
    }

    private static class BinaryAsSortedNumericDocValues
    extends SortedNumericDocValues {
        private final BinaryDocValues values;
        private BytesRef bytes;
        private final ByteArrayDataInput in = new ByteArrayDataInput();
        private long[] longs = new long[1];
        private int count = 0;

        BinaryAsSortedNumericDocValues(BinaryDocValues values) {
            this.values = values;
        }

        @Override
        public void setDocument(int docId) {
            this.bytes = this.values.get(docId);
            this.in.reset(this.bytes.bytes, this.bytes.offset, this.bytes.length);
            if (!this.in.eof()) {
                long previousValue = this.longs[0] = ByteUtils.zigZagDecode(ByteUtils.readVLong(this.in));
                this.count = 1;
                while (!this.in.eof()) {
                    this.longs = ArrayUtil.grow(this.longs, this.count + 1);
                    long l = previousValue + ByteUtils.readVLong(this.in);
                    this.longs[this.count++] = l;
                    previousValue = l;
                }
            } else {
                this.count = 0;
            }
        }

        @Override
        public int count() {
            return this.count;
        }

        @Override
        public long valueAt(int index) {
            return this.longs[index];
        }
    }
}

