/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query.functionscore;

import java.io.IOException;
import java.util.Locale;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.Explanation;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.geo.GeoDistance;
import org.elasticsearch.common.geo.GeoPoint;
import org.elasticsearch.common.geo.GeoUtils;
import org.elasticsearch.common.lucene.search.function.CombineFunction;
import org.elasticsearch.common.lucene.search.function.LeafScoreFunction;
import org.elasticsearch.common.lucene.search.function.ScoreFunction;
import org.elasticsearch.common.unit.DistanceUnit;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.fielddata.AtomicGeoPointFieldData;
import org.elasticsearch.index.fielddata.AtomicNumericFieldData;
import org.elasticsearch.index.fielddata.IndexGeoPointFieldData;
import org.elasticsearch.index.fielddata.IndexNumericFieldData;
import org.elasticsearch.index.fielddata.MultiGeoPointValues;
import org.elasticsearch.index.fielddata.NumericDoubleValues;
import org.elasticsearch.index.fielddata.SortedNumericDoubleValues;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.core.DateFieldMapper;
import org.elasticsearch.index.mapper.core.NumberFieldMapper;
import org.elasticsearch.index.mapper.geo.BaseGeoPointFieldMapper;
import org.elasticsearch.index.query.QueryParseContext;
import org.elasticsearch.index.query.QueryParsingException;
import org.elasticsearch.index.query.functionscore.DecayFunction;
import org.elasticsearch.index.query.functionscore.ScoreFunctionParser;
import org.elasticsearch.search.MultiValueMode;
import org.elasticsearch.search.internal.SearchContext;

public abstract class DecayFunctionParser
implements ScoreFunctionParser {
    public static final ParseField MULTI_VALUE_MODE = new ParseField("multi_value_mode", new String[0]);

    public abstract DecayFunction getDecayFunction();

    @Override
    public ScoreFunction parse(QueryParseContext parseContext, XContentParser parser) throws IOException, QueryParsingException {
        XContentParser.Token token;
        String multiValueMode = "MIN";
        XContentBuilder variableContent = XContentFactory.jsonBuilder();
        String fieldName = null;
        while ((token = parser.nextToken()) == XContentParser.Token.FIELD_NAME) {
            String currentFieldName = parser.currentName();
            token = parser.nextToken();
            if (token == XContentParser.Token.START_OBJECT) {
                variableContent.copyCurrentStructure(parser);
                fieldName = currentFieldName;
                continue;
            }
            if (parseContext.parseFieldMatcher().match(currentFieldName, MULTI_VALUE_MODE)) {
                multiValueMode = parser.text();
                continue;
            }
            throw new ElasticsearchParseException("malformed score function score parameters.", new Object[0]);
        }
        if (fieldName == null) {
            throw new ElasticsearchParseException("malformed score function score parameters.", new Object[0]);
        }
        XContentParser variableParser = XContentFactory.xContent(variableContent.string()).createParser(variableContent.string());
        AbstractDistanceScoreFunction scoreFunction = this.parseVariable(fieldName, variableParser, parseContext, MultiValueMode.fromString(multiValueMode.toUpperCase(Locale.ROOT)));
        return scoreFunction;
    }

    private AbstractDistanceScoreFunction parseVariable(String fieldName, XContentParser parser, QueryParseContext parseContext, MultiValueMode mode) throws IOException {
        MappedFieldType fieldType = parseContext.fieldMapper(fieldName);
        if (fieldType == null) {
            throw new QueryParsingException(parseContext, "unknown field [{}]", fieldName);
        }
        parser.nextToken();
        if (fieldType instanceof DateFieldMapper.DateFieldType) {
            return this.parseDateVariable(fieldName, parser, parseContext, (DateFieldMapper.DateFieldType)fieldType, mode);
        }
        if (fieldType instanceof BaseGeoPointFieldMapper.GeoPointFieldType) {
            return this.parseGeoVariable(fieldName, parser, parseContext, (BaseGeoPointFieldMapper.GeoPointFieldType)fieldType, mode);
        }
        if (fieldType instanceof NumberFieldMapper.NumberFieldType) {
            return this.parseNumberVariable(fieldName, parser, parseContext, (NumberFieldMapper.NumberFieldType)fieldType, mode);
        }
        throw new QueryParsingException(parseContext, "field [{}] is of type [{}], but only numeric types are supported.", fieldName, fieldType);
    }

    private AbstractDistanceScoreFunction parseNumberVariable(String fieldName, XContentParser parser, QueryParseContext parseContext, NumberFieldMapper.NumberFieldType fieldType, MultiValueMode mode) throws IOException {
        XContentParser.Token token;
        String parameterName = null;
        double scale = 0.0;
        double origin = 0.0;
        double decay = 0.5;
        double offset = 0.0;
        boolean scaleFound = false;
        boolean refFound = false;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                parameterName = parser.currentName();
                continue;
            }
            if (parameterName.equals("scale")) {
                scale = parser.doubleValue();
                scaleFound = true;
                continue;
            }
            if (parameterName.equals("decay")) {
                decay = parser.doubleValue();
                continue;
            }
            if (parameterName.equals("origin")) {
                origin = parser.doubleValue();
                refFound = true;
                continue;
            }
            if (parameterName.equals("offset")) {
                offset = parser.doubleValue();
                continue;
            }
            throw new ElasticsearchParseException("parameter [{}] not supported!", parameterName);
        }
        if (!scaleFound || !refFound) {
            throw new ElasticsearchParseException("both [{}] and [{}] must be set for numeric fields.", "scale", "origin");
        }
        IndexNumericFieldData numericFieldData = (IndexNumericFieldData)parseContext.getForField(fieldType);
        return new NumericFieldDataScoreFunction(origin, scale, decay, offset, this.getDecayFunction(), numericFieldData, mode);
    }

    private AbstractDistanceScoreFunction parseGeoVariable(String fieldName, XContentParser parser, QueryParseContext parseContext, BaseGeoPointFieldMapper.GeoPointFieldType fieldType, MultiValueMode mode) throws IOException {
        XContentParser.Token token;
        String parameterName = null;
        GeoPoint origin = new GeoPoint();
        String scaleString = null;
        String offsetString = "0km";
        double decay = 0.5;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                parameterName = parser.currentName();
                continue;
            }
            if (parameterName.equals("scale")) {
                scaleString = parser.text();
                continue;
            }
            if (parameterName.equals("origin")) {
                origin = GeoUtils.parseGeoPoint(parser);
                continue;
            }
            if (parameterName.equals("decay")) {
                decay = parser.doubleValue();
                continue;
            }
            if (parameterName.equals("offset")) {
                offsetString = parser.text();
                continue;
            }
            throw new ElasticsearchParseException("parameter [{}] not supported!", parameterName);
        }
        if (origin == null || scaleString == null) {
            throw new ElasticsearchParseException("[{}] and [{}] must be set for geo fields.", "origin", "scale");
        }
        double scale = DistanceUnit.DEFAULT.parse(scaleString, DistanceUnit.DEFAULT);
        double offset = DistanceUnit.DEFAULT.parse(offsetString, DistanceUnit.DEFAULT);
        IndexGeoPointFieldData indexFieldData = (IndexGeoPointFieldData)parseContext.getForField(fieldType);
        return new GeoFieldDataScoreFunction(origin, scale, decay, offset, this.getDecayFunction(), indexFieldData, mode);
    }

    private AbstractDistanceScoreFunction parseDateVariable(String fieldName, XContentParser parser, QueryParseContext parseContext, DateFieldMapper.DateFieldType dateFieldType, MultiValueMode mode) throws IOException {
        XContentParser.Token token;
        String parameterName = null;
        String scaleString = null;
        String originString = null;
        String offsetString = "0d";
        double decay = 0.5;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                parameterName = parser.currentName();
                continue;
            }
            if (parameterName.equals("scale")) {
                scaleString = parser.text();
                continue;
            }
            if (parameterName.equals("origin")) {
                originString = parser.text();
                continue;
            }
            if (parameterName.equals("decay")) {
                decay = parser.doubleValue();
                continue;
            }
            if (parameterName.equals("offset")) {
                offsetString = parser.text();
                continue;
            }
            throw new ElasticsearchParseException("parameter [{}] not supported!", parameterName);
        }
        long origin = SearchContext.current().nowInMillis();
        if (originString != null) {
            origin = dateFieldType.parseToMilliseconds(originString, false, null, null);
        }
        if (scaleString == null) {
            throw new ElasticsearchParseException("[{}] must be set for date fields.", "scale");
        }
        TimeValue val = TimeValue.parseTimeValue(scaleString, TimeValue.timeValueHours(24L), this.getClass().getSimpleName() + ".scale");
        double scale = val.getMillis();
        val = TimeValue.parseTimeValue(offsetString, TimeValue.timeValueHours(24L), this.getClass().getSimpleName() + ".offset");
        double offset = val.getMillis();
        IndexNumericFieldData numericFieldData = (IndexNumericFieldData)parseContext.getForField(dateFieldType);
        return new NumericFieldDataScoreFunction(origin, scale, decay, offset, this.getDecayFunction(), numericFieldData, mode);
    }

    public static abstract class AbstractDistanceScoreFunction
    extends ScoreFunction {
        private final double scale;
        protected final double offset;
        private final DecayFunction func;
        protected final MultiValueMode mode;

        public AbstractDistanceScoreFunction(double userSuppiedScale, double decay, double offset, DecayFunction func, MultiValueMode mode) {
            super(CombineFunction.MULT);
            this.mode = mode;
            if (userSuppiedScale <= 0.0) {
                throw new IllegalArgumentException("function_score : scale must be > 0.0.");
            }
            if (decay <= 0.0 || decay >= 1.0) {
                throw new IllegalArgumentException("function_score : decay must be in the range [0..1].");
            }
            this.scale = func.processScale(userSuppiedScale, decay);
            this.func = func;
            if (offset < 0.0) {
                throw new IllegalArgumentException("function_score : offset must be > 0.0");
            }
            this.offset = offset;
        }

        protected abstract NumericDoubleValues distance(LeafReaderContext var1);

        @Override
        public final LeafScoreFunction getLeafScoreFunction(final LeafReaderContext ctx) {
            final NumericDoubleValues distance = this.distance(ctx);
            return new LeafScoreFunction(){

                @Override
                public double score(int docId, float subQueryScore) {
                    return AbstractDistanceScoreFunction.this.func.evaluate(distance.get(docId), AbstractDistanceScoreFunction.this.scale);
                }

                @Override
                public Explanation explainScore(int docId, Explanation subQueryScore) throws IOException {
                    return Explanation.match(CombineFunction.toFloat(this.score(docId, subQueryScore.getValue())), "Function for field " + AbstractDistanceScoreFunction.this.getFieldName() + ":", AbstractDistanceScoreFunction.this.func.explainFunction(AbstractDistanceScoreFunction.this.getDistanceString(ctx, docId), distance.get(docId), AbstractDistanceScoreFunction.this.scale));
                }
            };
        }

        protected abstract String getDistanceString(LeafReaderContext var1, int var2);

        protected abstract String getFieldName();
    }

    static class NumericFieldDataScoreFunction
    extends AbstractDistanceScoreFunction {
        private final IndexNumericFieldData fieldData;
        private final double origin;

        public NumericFieldDataScoreFunction(double origin, double scale, double decay, double offset, DecayFunction func, IndexNumericFieldData fieldData, MultiValueMode mode) {
            super(scale, decay, offset, func, mode);
            this.fieldData = fieldData;
            this.origin = origin;
        }

        @Override
        public boolean needsScores() {
            return false;
        }

        @Override
        protected NumericDoubleValues distance(LeafReaderContext context) {
            final SortedNumericDoubleValues doubleValues = ((AtomicNumericFieldData)this.fieldData.load(context)).getDoubleValues();
            return this.mode.select(new MultiValueMode.UnsortedNumericDoubleValues(){

                @Override
                public int count() {
                    return doubleValues.count();
                }

                @Override
                public void setDocument(int docId) {
                    doubleValues.setDocument(docId);
                }

                @Override
                public double valueAt(int index) {
                    return Math.max(0.0, Math.abs(doubleValues.valueAt(index) - NumericFieldDataScoreFunction.this.origin) - NumericFieldDataScoreFunction.this.offset);
                }
            }, 0.0);
        }

        @Override
        protected String getDistanceString(LeafReaderContext ctx, int docId) {
            StringBuilder values = new StringBuilder(this.mode.name());
            values.append("[");
            SortedNumericDoubleValues doubleValues = ((AtomicNumericFieldData)this.fieldData.load(ctx)).getDoubleValues();
            doubleValues.setDocument(docId);
            int num = doubleValues.count();
            if (num > 0) {
                for (int i = 0; i < num; ++i) {
                    double value = doubleValues.valueAt(i);
                    values.append("Math.max(Math.abs(");
                    values.append(value).append("(=doc value) - ").append(this.origin).append("(=origin))) - ").append(this.offset).append("(=offset), 0)");
                    if (i == num - 1) continue;
                    values.append(", ");
                }
            } else {
                values.append("0.0");
            }
            values.append("]");
            return values.toString();
        }

        @Override
        protected String getFieldName() {
            return this.fieldData.getFieldNames().fullName();
        }
    }

    static class GeoFieldDataScoreFunction
    extends AbstractDistanceScoreFunction {
        private final GeoPoint origin;
        private final IndexGeoPointFieldData fieldData;
        private static final GeoDistance distFunction = GeoDistance.DEFAULT;

        public GeoFieldDataScoreFunction(GeoPoint origin, double scale, double decay, double offset, DecayFunction func, IndexGeoPointFieldData fieldData, MultiValueMode mode) {
            super(scale, decay, offset, func, mode);
            this.origin = origin;
            this.fieldData = fieldData;
        }

        @Override
        public boolean needsScores() {
            return false;
        }

        @Override
        protected NumericDoubleValues distance(LeafReaderContext context) {
            final MultiGeoPointValues geoPointValues = ((AtomicGeoPointFieldData)this.fieldData.load(context)).getGeoPointValues();
            return this.mode.select(new MultiValueMode.UnsortedNumericDoubleValues(){

                @Override
                public int count() {
                    return geoPointValues.count();
                }

                @Override
                public void setDocument(int docId) {
                    geoPointValues.setDocument(docId);
                }

                @Override
                public double valueAt(int index) {
                    GeoPoint other = geoPointValues.valueAt(index);
                    return Math.max(0.0, distFunction.calculate(GeoFieldDataScoreFunction.this.origin.lat(), GeoFieldDataScoreFunction.this.origin.lon(), other.lat(), other.lon(), DistanceUnit.METERS) - GeoFieldDataScoreFunction.this.offset);
                }
            }, 0.0);
        }

        @Override
        protected String getDistanceString(LeafReaderContext ctx, int docId) {
            StringBuilder values = new StringBuilder(this.mode.name());
            values.append(" of: [");
            MultiGeoPointValues geoPointValues = ((AtomicGeoPointFieldData)this.fieldData.load(ctx)).getGeoPointValues();
            geoPointValues.setDocument(docId);
            int num = geoPointValues.count();
            if (num > 0) {
                for (int i = 0; i < num; ++i) {
                    GeoPoint value = geoPointValues.valueAt(i);
                    values.append("Math.max(arcDistance(");
                    values.append(value).append("(=doc value),").append(this.origin).append("(=origin)) - ").append(this.offset).append("(=offset), 0)");
                    if (i == num - 1) continue;
                    values.append(", ");
                }
            } else {
                values.append("0.0");
            }
            values.append("]");
            return values.toString();
        }

        @Override
        protected String getFieldName() {
            return this.fieldData.getFieldNames().fullName();
        }
    }
}

