/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query.functionscore.fieldvaluefactor;

import java.io.IOException;
import java.util.Locale;
import org.elasticsearch.common.lucene.search.function.FieldValueFactorFunction;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.query.functionscore.ScoreFunctionBuilder;
import org.elasticsearch.index.query.functionscore.fieldvaluefactor.FieldValueFactorFunctionParser;

public class FieldValueFactorFunctionBuilder
extends ScoreFunctionBuilder {
    private String field = null;
    private Float factor = null;
    private Double missing = null;
    private FieldValueFactorFunction.Modifier modifier = null;

    public FieldValueFactorFunctionBuilder(String fieldName) {
        this.field = fieldName;
    }

    @Override
    public String getName() {
        return FieldValueFactorFunctionParser.NAMES[0];
    }

    public FieldValueFactorFunctionBuilder factor(float boostFactor) {
        this.factor = Float.valueOf(boostFactor);
        return this;
    }

    public FieldValueFactorFunctionBuilder missing(double missing) {
        this.missing = missing;
        return this;
    }

    public FieldValueFactorFunctionBuilder modifier(FieldValueFactorFunction.Modifier modifier) {
        this.modifier = modifier;
        return this;
    }

    @Override
    public void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(this.getName());
        if (this.field != null) {
            builder.field("field", this.field);
        }
        if (this.factor != null) {
            builder.field("factor", this.factor);
        }
        if (this.missing != null) {
            builder.field("missing", this.missing);
        }
        if (this.modifier != null) {
            builder.field("modifier", this.modifier.toString().toLowerCase(Locale.ROOT));
        }
        builder.endObject();
    }
}

