/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.translog;

import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Objects;
import org.apache.lucene.store.ByteArrayDataOutput;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.DataOutput;
import org.apache.lucene.store.InputStreamDataInput;
import org.elasticsearch.common.io.Channels;

class Checkpoint {
    static final int BUFFER_SIZE = 20;
    final long offset;
    final int numOps;
    final long generation;

    Checkpoint(long offset, int numOps, long generation) {
        this.offset = offset;
        this.numOps = numOps;
        this.generation = generation;
    }

    Checkpoint(DataInput in) throws IOException {
        this.offset = in.readLong();
        this.numOps = in.readInt();
        this.generation = in.readLong();
    }

    private void write(FileChannel channel) throws IOException {
        byte[] buffer = new byte[20];
        ByteArrayDataOutput out = new ByteArrayDataOutput(buffer);
        this.write(out);
        Channels.writeToChannel(buffer, (WritableByteChannel)channel);
    }

    private void write(DataOutput out) throws IOException {
        out.writeLong(this.offset);
        out.writeInt(this.numOps);
        out.writeLong(this.generation);
    }

    public String toString() {
        return "Checkpoint{offset=" + this.offset + ", numOps=" + this.numOps + ", translogFileGeneration= " + this.generation + '}';
    }

    public static Checkpoint read(Path path) throws IOException {
        try (InputStream in = Files.newInputStream(path, new OpenOption[0]);){
            Checkpoint checkpoint = new Checkpoint(new InputStreamDataInput(in));
            return checkpoint;
        }
    }

    public static void write(Path checkpointFile, Checkpoint checkpoint, OpenOption ... options) throws IOException {
        try (FileChannel channel = FileChannel.open(checkpointFile, options);){
            checkpoint.write(channel);
            channel.force(false);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Checkpoint that = (Checkpoint)o;
        if (this.offset != that.offset) {
            return false;
        }
        if (this.numOps != that.numOps) {
            return false;
        }
        return this.generation == that.generation;
    }

    public int hashCode() {
        return Objects.hash(this.offset, this.numOps, this.generation);
    }
}

