/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.indices;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Maps;
import java.io.Closeable;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.lucene.store.LockObtainFailedException;
import org.apache.lucene.util.CollectionUtil;
import org.apache.lucene.util.IOUtils;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.admin.indices.stats.CommonStats;
import org.elasticsearch.action.admin.indices.stats.CommonStatsFlags;
import org.elasticsearch.action.admin.indices.stats.IndexShardStats;
import org.elasticsearch.action.admin.indices.stats.ShardStats;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.collect.MapBuilder;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.common.inject.CreationException;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.Injector;
import org.elasticsearch.common.inject.Injectors;
import org.elasticsearch.common.inject.Module;
import org.elasticsearch.common.inject.ModulesBuilder;
import org.elasticsearch.common.io.FileSystemUtils;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.CollectionUtils;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.env.NodeEnvironment;
import org.elasticsearch.env.ShardLock;
import org.elasticsearch.gateway.MetaDataStateFormat;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexModule;
import org.elasticsearch.index.IndexNameModule;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.index.IndexService;
import org.elasticsearch.index.LocalNodeIdModule;
import org.elasticsearch.index.aliases.IndexAliasesServiceModule;
import org.elasticsearch.index.analysis.AnalysisModule;
import org.elasticsearch.index.analysis.AnalysisService;
import org.elasticsearch.index.cache.IndexCache;
import org.elasticsearch.index.cache.IndexCacheModule;
import org.elasticsearch.index.fielddata.IndexFieldDataModule;
import org.elasticsearch.index.fielddata.IndexFieldDataService;
import org.elasticsearch.index.flush.FlushStats;
import org.elasticsearch.index.get.GetStats;
import org.elasticsearch.index.indexing.IndexingStats;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.mapper.MapperServiceModule;
import org.elasticsearch.index.merge.MergeStats;
import org.elasticsearch.index.query.IndexQueryParserService;
import org.elasticsearch.index.recovery.RecoveryStats;
import org.elasticsearch.index.refresh.RefreshStats;
import org.elasticsearch.index.search.stats.SearchStats;
import org.elasticsearch.index.settings.IndexSettingsModule;
import org.elasticsearch.index.shard.IllegalIndexShardStateException;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.similarity.SimilarityModule;
import org.elasticsearch.index.store.IndexStore;
import org.elasticsearch.index.store.IndexStoreModule;
import org.elasticsearch.indices.IndexAlreadyExistsException;
import org.elasticsearch.indices.IndexCreationException;
import org.elasticsearch.indices.IndicesLifecycle;
import org.elasticsearch.indices.InternalIndicesLifecycle;
import org.elasticsearch.indices.NodeIndicesStats;
import org.elasticsearch.indices.analysis.IndicesAnalysisService;
import org.elasticsearch.indices.recovery.RecoverySettings;
import org.elasticsearch.plugins.PluginsService;

public class IndicesService
extends AbstractLifecycleComponent<IndicesService>
implements Iterable<IndexService> {
    public static final String INDICES_SHARDS_CLOSED_TIMEOUT = "indices.shards_closed_timeout";
    private final InternalIndicesLifecycle indicesLifecycle;
    private final IndicesAnalysisService indicesAnalysisService;
    private final Injector injector;
    private final PluginsService pluginsService;
    private final NodeEnvironment nodeEnv;
    private final TimeValue shardsClosedTimeout;
    private volatile Map<String, IndexServiceInjectorPair> indices = ImmutableMap.of();
    private final Map<Index, List<PendingDelete>> pendingDeletes = new HashMap<Index, List<PendingDelete>>();
    private final OldShardsStats oldShardsStats = new OldShardsStats();

    @Inject
    public IndicesService(Settings settings, IndicesLifecycle indicesLifecycle, IndicesAnalysisService indicesAnalysisService, Injector injector, NodeEnvironment nodeEnv) {
        super(settings);
        this.indicesLifecycle = (InternalIndicesLifecycle)indicesLifecycle;
        this.indicesAnalysisService = indicesAnalysisService;
        this.injector = injector;
        this.pluginsService = injector.getInstance(PluginsService.class);
        this.indicesLifecycle.addListener(this.oldShardsStats);
        this.nodeEnv = nodeEnv;
        this.shardsClosedTimeout = settings.getAsTime(INDICES_SHARDS_CLOSED_TIMEOUT, new TimeValue(1L, TimeUnit.DAYS));
    }

    @Override
    protected void doStart() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doStop() {
        ImmutableSet indices = ImmutableSet.copyOf(this.indices.keySet());
        final CountDownLatch latch = new CountDownLatch(indices.size());
        ExecutorService indicesStopExecutor = Executors.newFixedThreadPool(5, EsExecutors.daemonThreadFactory("indices_shutdown"));
        for (final String index : indices) {
            indicesStopExecutor.execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        IndicesService.this.removeIndex(index, "shutdown", false);
                    }
                    catch (Throwable e) {
                        IndicesService.this.logger.warn("failed to remove index on stop [" + index + "]", e, new Object[0]);
                    }
                    finally {
                        latch.countDown();
                    }
                }
            });
        }
        try {
            if (!latch.await(this.shardsClosedTimeout.seconds(), TimeUnit.SECONDS)) {
                this.logger.warn("Not all shards are closed yet, waited {}sec - stopping service", this.shardsClosedTimeout.seconds());
            }
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            indicesStopExecutor.shutdown();
        }
    }

    @Override
    protected void doClose() {
        IOUtils.closeWhileHandlingException(this.injector.getInstance(RecoverySettings.class), this.indicesAnalysisService);
    }

    public IndicesLifecycle indicesLifecycle() {
        return this.indicesLifecycle;
    }

    public NodeIndicesStats stats(boolean includePrevious) {
        return this.stats(includePrevious, new CommonStatsFlags(new CommonStatsFlags.Flag[0]).all());
    }

    public NodeIndicesStats stats(boolean includePrevious, CommonStatsFlags flags) {
        CommonStats oldStats = new CommonStats(flags);
        if (includePrevious) {
            CommonStatsFlags.Flag[] setFlags;
            block11: for (CommonStatsFlags.Flag flag : setFlags = flags.getFlags()) {
                switch (flag) {
                    case Get: {
                        oldStats.get.add(this.oldShardsStats.getStats);
                        continue block11;
                    }
                    case Indexing: {
                        oldStats.indexing.add(this.oldShardsStats.indexingStats);
                        continue block11;
                    }
                    case Search: {
                        oldStats.search.add(this.oldShardsStats.searchStats);
                        continue block11;
                    }
                    case Merge: {
                        oldStats.merge.add(this.oldShardsStats.mergeStats);
                        continue block11;
                    }
                    case Refresh: {
                        oldStats.refresh.add(this.oldShardsStats.refreshStats);
                        continue block11;
                    }
                    case Recovery: {
                        oldStats.recoveryStats.add(this.oldShardsStats.recoveryStats);
                        continue block11;
                    }
                    case Flush: {
                        oldStats.flush.add(this.oldShardsStats.flushStats);
                    }
                }
            }
        }
        HashMap statsByShard = Maps.newHashMap();
        for (IndexServiceInjectorPair value : this.indices.values()) {
            IndexService indexService = value.getIndexService();
            for (IndexShard indexShard : indexService) {
                try {
                    if (indexShard.routingEntry() == null) continue;
                    IndexShardStats indexShardStats = new IndexShardStats(indexShard.shardId(), new ShardStats[]{new ShardStats(indexShard.routingEntry(), indexShard.shardPath(), new CommonStats(indexShard, flags), indexShard.commitStats())});
                    if (!statsByShard.containsKey(indexService.index())) {
                        statsByShard.put(indexService.index(), CollectionUtils.arrayAsArrayList(indexShardStats));
                        continue;
                    }
                    ((List)statsByShard.get(indexService.index())).add(indexShardStats);
                }
                catch (IllegalIndexShardStateException e) {
                    this.logger.trace("{} ignoring shard stats", e, indexShard.shardId());
                }
            }
        }
        return new NodeIndicesStats(oldStats, statsByShard);
    }

    public boolean changesAllowed() {
        return this.lifecycle.started();
    }

    @Override
    public Iterator<IndexService> iterator() {
        return Iterators.transform(this.indices.values().iterator(), (Function)new Function<IndexServiceInjectorPair, IndexService>(){

            public IndexService apply(IndexServiceInjectorPair input) {
                return input.getIndexService();
            }
        });
    }

    public boolean hasIndex(String index) {
        return this.indices.containsKey(index);
    }

    @Nullable
    public IndexService indexService(String index) {
        IndexServiceInjectorPair indexServiceInjectorPair = this.indices.get(index);
        if (indexServiceInjectorPair == null) {
            return null;
        }
        return indexServiceInjectorPair.getIndexService();
    }

    public IndexService indexServiceSafe(String index) {
        IndexService indexService = this.indexService(index);
        if (indexService == null) {
            throw new IndexNotFoundException(index);
        }
        return indexService;
    }

    public synchronized IndexService createIndex(String sIndexName, Settings settings, String localNodeId) {
        Injector indexInjector;
        if (!this.lifecycle.started()) {
            throw new IllegalStateException("Can't create an index [" + sIndexName + "], node is closed");
        }
        Index index = new Index(sIndexName);
        if (this.indices.containsKey(index.name())) {
            throw new IndexAlreadyExistsException(index);
        }
        this.indicesLifecycle.beforeIndexCreated(index, settings);
        this.logger.debug("creating Index [{}], shards [{}]/[{}{}]", sIndexName, settings.get("index.number_of_shards"), settings.get("index.number_of_replicas"), IndexMetaData.isIndexUsingShadowReplicas(settings) ? "s" : "");
        Settings indexSettings = Settings.settingsBuilder().put(this.settings).put(settings).build();
        ModulesBuilder modules = new ModulesBuilder();
        modules.add(new IndexNameModule(index));
        modules.add(new LocalNodeIdModule(localNodeId));
        modules.add(new IndexSettingsModule(index, indexSettings));
        for (Module pluginModule : this.pluginsService.indexModules(indexSettings)) {
            modules.add(pluginModule);
        }
        modules.add(new IndexStoreModule(indexSettings));
        modules.add(new AnalysisModule(indexSettings, this.indicesAnalysisService));
        modules.add(new SimilarityModule(indexSettings));
        modules.add(new IndexCacheModule(indexSettings));
        modules.add(new IndexFieldDataModule(indexSettings));
        modules.add(new MapperServiceModule());
        modules.add(new IndexAliasesServiceModule());
        modules.add(new IndexModule(indexSettings));
        this.pluginsService.processModules(modules);
        try {
            indexInjector = modules.createChildInjector(this.injector);
        }
        catch (CreationException e) {
            throw new IndexCreationException(index, Injectors.getFirstErrorFailure(e));
        }
        catch (Throwable e) {
            throw new IndexCreationException(index, e);
        }
        IndexService indexService = indexInjector.getInstance(IndexService.class);
        this.indicesLifecycle.afterIndexCreated(indexService);
        this.indices = MapBuilder.newMapBuilder(this.indices).put(index.name(), new IndexServiceInjectorPair(indexService, indexInjector)).immutableMap();
        return indexService;
    }

    public void removeIndex(String index, String reason) {
        this.removeIndex(index, reason, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeIndex(String index, String reason, boolean delete) {
        try {
            Injector indexInjector;
            IndexService indexService;
            IndicesService indicesService = this;
            synchronized (indicesService) {
                if (!this.indices.containsKey(index)) {
                    return;
                }
                this.logger.debug("[{}] closing ... (reason [{}])", index, reason);
                HashMap tmpMap = Maps.newHashMap(this.indices);
                IndexServiceInjectorPair remove = (IndexServiceInjectorPair)tmpMap.remove(index);
                indexService = remove.getIndexService();
                indexInjector = remove.getInjector();
                this.indices = ImmutableMap.copyOf((Map)tmpMap);
            }
            this.indicesLifecycle.beforeIndexClosed(indexService);
            if (delete) {
                this.indicesLifecycle.beforeIndexDeleted(indexService);
            }
            IOUtils.close(Iterables.transform(this.pluginsService.indexServices(), (Function)new Function<Class<? extends Closeable>, Closeable>(){

                public Closeable apply(Class<? extends Closeable> input) {
                    return indexInjector.getInstance(input);
                }
            }));
            this.logger.debug("[{}] closing index service (reason [{}])", index, reason);
            indexService.close(reason, delete);
            this.logger.debug("[{}] closing index cache (reason [{}])", index, reason);
            indexInjector.getInstance(IndexCache.class).close();
            this.logger.debug("[{}] clearing index field data (reason [{}])", index, reason);
            indexInjector.getInstance(IndexFieldDataService.class).clear();
            this.logger.debug("[{}] closing analysis service (reason [{}])", index, reason);
            indexInjector.getInstance(AnalysisService.class).close();
            this.logger.debug("[{}] closing mapper service (reason [{}])", index, reason);
            indexInjector.getInstance(MapperService.class).close();
            this.logger.debug("[{}] closing index query parser service (reason [{}])", index, reason);
            indexInjector.getInstance(IndexQueryParserService.class).close();
            this.logger.debug("[{}] closing index service (reason [{}])", index, reason);
            indexInjector.getInstance(IndexStore.class).close();
            this.logger.debug("[{}] closed... (reason [{}])", index, reason);
            this.indicesLifecycle.afterIndexClosed(indexService.index(), indexService.indexSettings());
            if (delete) {
                Settings indexSettings = indexService.indexSettings();
                this.indicesLifecycle.afterIndexDeleted(indexService.index(), indexSettings);
                this.deleteIndexStore(reason, indexService.index(), indexSettings, false);
            }
        }
        catch (IOException ex) {
            throw new ElasticsearchException("failed to remove index " + index, (Throwable)ex, new Object[0]);
        }
    }

    public void deleteIndex(String index, String reason) throws IOException {
        this.removeIndex(index, reason, true);
    }

    public void deleteClosedIndex(String reason, IndexMetaData metaData, ClusterState clusterState) {
        if (this.nodeEnv.hasNodeFile()) {
            String indexName = metaData.getIndex();
            try {
                if (clusterState.metaData().hasIndex(indexName)) {
                    IndexMetaData index = clusterState.metaData().index(indexName);
                    throw new IllegalStateException("Can't delete closed index store for [" + indexName + "] - it's still part of the cluster state [" + index.getIndexUUID() + "] [" + metaData.getIndexUUID() + "]");
                }
                this.deleteIndexStore(reason, metaData, clusterState, true);
            }
            catch (IOException e) {
                this.logger.warn("[{}] failed to delete closed index", e, metaData.getIndex());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteIndexStore(String reason, IndexMetaData metaData, ClusterState clusterState, boolean closed) throws IOException {
        if (this.nodeEnv.hasNodeFile()) {
            IndicesService indicesService = this;
            synchronized (indicesService) {
                String indexName = metaData.getIndex();
                if (this.indices.containsKey(indexName)) {
                    String localUUid = this.indices.get(indexName).getIndexService().indexUUID();
                    throw new IllegalStateException("Can't delete index store for [" + indexName + "] - it's still part of the indices service [" + localUUid + "] [" + metaData.getIndexUUID() + "]");
                }
                if (clusterState.metaData().hasIndex(indexName) && clusterState.nodes().localNode().masterNode()) {
                    IndexMetaData index = clusterState.metaData().index(indexName);
                    throw new IllegalStateException("Can't delete closed index store for [" + indexName + "] - it's still part of the cluster state [" + index.getIndexUUID() + "] [" + metaData.getIndexUUID() + "]");
                }
            }
            Index index = new Index(metaData.getIndex());
            Settings indexSettings = this.buildIndexSettings(metaData);
            this.deleteIndexStore(reason, index, indexSettings, closed);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteIndexStore(String reason, Index index, Settings indexSettings, boolean closed) throws IOException {
        boolean success = false;
        try {
            this.logger.debug("{} deleting index store reason [{}]", index, reason);
            if (this.canDeleteIndexContents(index, indexSettings, closed)) {
                this.nodeEnv.deleteIndexDirectorySafe(index, 0L, indexSettings);
            }
            success = true;
        }
        catch (LockObtainFailedException ex) {
            this.logger.debug("{} failed to delete index store - at least one shards is still locked", ex, index);
        }
        catch (Exception ex) {
            this.logger.warn("{} failed to delete index", ex, index);
        }
        finally {
            if (!success) {
                this.addPendingDelete(index, indexSettings);
            }
            MetaDataStateFormat.deleteMetaState(this.nodeEnv.indexPaths(index));
        }
    }

    public void deleteShardStore(String reason, ShardLock lock, Settings indexSettings) throws IOException {
        ShardId shardId = lock.getShardId();
        this.logger.trace("{} deleting shard reason [{}]", shardId, reason);
        this.nodeEnv.deleteShardDirectoryUnderLock(lock, indexSettings);
    }

    public void deleteShardStore(String reason, ShardId shardId, ClusterState clusterState) throws IOException {
        IndexMetaData metaData = clusterState.getMetaData().indices().get(shardId.getIndex());
        Settings indexSettings = this.buildIndexSettings(metaData);
        if (!this.canDeleteShardContent(shardId, indexSettings)) {
            throw new IllegalStateException("Can't delete shard " + shardId);
        }
        this.nodeEnv.deleteShardDirectorySafe(shardId, indexSettings);
        this.logger.debug("{} deleted shard reason [{}]", shardId, reason);
        if (!clusterState.nodes().localNode().isMasterNode() && this.canDeleteIndexContents(shardId.index(), indexSettings, false)) {
            if (this.nodeEnv.findAllShardIds(shardId.index()).isEmpty()) {
                try {
                    this.deleteIndexStore("no longer used", metaData, clusterState, false);
                }
                catch (Exception e) {
                    throw new ElasticsearchException("failed to delete unused index after deleting its last shard (" + shardId + ")", (Throwable)e, new Object[0]);
                }
            } else {
                this.logger.trace("[{}] still has shard stores, leaving as is", shardId.index());
            }
        }
    }

    public boolean canDeleteIndexContents(Index index, Settings indexSettings, boolean closed) {
        IndexServiceInjectorPair indexServiceInjectorPair = this.indices.get(index.name());
        if (!IndexMetaData.isOnSharedFilesystem(indexSettings) || closed) {
            if (indexServiceInjectorPair == null && this.nodeEnv.hasNodeFile()) {
                return true;
            }
        } else {
            this.logger.trace("{} skipping index directory deletion due to shadow replicas", index);
        }
        return false;
    }

    public boolean canDeleteShardContent(ShardId shardId, IndexMetaData metaData) {
        assert (shardId.getIndex().equals(metaData.getIndex()));
        Settings indexSettings = this.buildIndexSettings(metaData);
        return this.canDeleteShardContent(shardId, indexSettings);
    }

    private boolean canDeleteShardContent(ShardId shardId, Settings indexSettings) {
        IndexServiceInjectorPair indexServiceInjectorPair = this.indices.get(shardId.getIndex());
        if (!IndexMetaData.isOnSharedFilesystem(indexSettings)) {
            if (this.nodeEnv.hasNodeFile()) {
                boolean isAllocated;
                boolean bl = isAllocated = indexServiceInjectorPair != null && indexServiceInjectorPair.getIndexService().hasShard(shardId.getId());
                if (isAllocated) {
                    return false;
                }
                if (NodeEnvironment.hasCustomDataPath(indexSettings)) {
                    return Files.exists(this.nodeEnv.resolveCustomLocation(indexSettings, shardId), new LinkOption[0]);
                }
                return FileSystemUtils.exists(this.nodeEnv.availableShardPaths(shardId));
            }
        } else {
            this.logger.trace("{} skipping shard directory deletion due to shadow replicas", shardId);
        }
        return false;
    }

    private Settings buildIndexSettings(IndexMetaData metaData) {
        Settings.Builder builder = Settings.settingsBuilder();
        builder.put(this.settings);
        builder.put(metaData.getSettings());
        return builder.build();
    }

    public void addPendingDelete(ShardId shardId, Settings settings) {
        if (shardId == null) {
            throw new IllegalArgumentException("shardId must not be null");
        }
        if (settings == null) {
            throw new IllegalArgumentException("settings must not be null");
        }
        PendingDelete pendingDelete = new PendingDelete(shardId, settings);
        this.addPendingDelete(shardId.index(), pendingDelete);
    }

    public void addPendingDelete(Index index, Settings settings) {
        PendingDelete pendingDelete = new PendingDelete(index, settings);
        this.addPendingDelete(index, pendingDelete);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addPendingDelete(Index index, PendingDelete pendingDelete) {
        Map<Index, List<PendingDelete>> map = this.pendingDeletes;
        synchronized (map) {
            List<PendingDelete> list = this.pendingDeletes.get(index);
            if (list == null) {
                list = new ArrayList<PendingDelete>();
                this.pendingDeletes.put(index, list);
            }
            list.add(pendingDelete);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processPendingDeletes(Index index, Settings indexSettings, TimeValue timeout) throws IOException, InterruptedException {
        block18: {
            this.logger.debug("{} processing pending deletes", index);
            long startTimeNS = System.nanoTime();
            List<ShardLock> shardLocks = this.nodeEnv.lockAllForIndex(index, indexSettings, timeout.millis());
            try {
                List<PendingDelete> remove;
                HashMap<ShardId, ShardLock> locks = new HashMap<ShardId, ShardLock>();
                for (ShardLock shardLock : shardLocks) {
                    locks.put(shardLock.getShardId(), shardLock);
                }
                Map<Index, List<PendingDelete>> map = this.pendingDeletes;
                synchronized (map) {
                    remove = this.pendingDeletes.remove(index);
                }
                if (remove == null || remove.isEmpty()) break block18;
                CollectionUtil.timSort(remove);
                long l = 10000L;
                long sleepTime = 10L;
                do {
                    if (remove.isEmpty()) {
                        break;
                    }
                    Iterator<PendingDelete> iterator = remove.iterator();
                    while (iterator.hasNext()) {
                        PendingDelete delete = iterator.next();
                        if (delete.deleteIndex) {
                            assert (delete.shardId == -1);
                            this.logger.debug("{} deleting index store reason [{}]", index, "pending delete");
                            try {
                                this.nodeEnv.deleteIndexDirectoryUnderLock(index, indexSettings);
                                iterator.remove();
                            }
                            catch (IOException ex) {
                                this.logger.debug("{} retry pending delete", ex, index);
                            }
                            continue;
                        }
                        assert (delete.shardId != -1);
                        ShardLock shardLock = (ShardLock)locks.get(new ShardId(delete.index, delete.shardId));
                        if (shardLock != null) {
                            try {
                                this.deleteShardStore("pending delete", shardLock, delete.settings);
                                iterator.remove();
                            }
                            catch (IOException ex) {
                                this.logger.debug("{} retry pending delete", ex, shardLock.getShardId());
                            }
                            continue;
                        }
                        this.logger.warn("{} no shard lock for pending delete", delete.shardId);
                        iterator.remove();
                    }
                    if (remove.isEmpty()) continue;
                    this.logger.warn("{} still pending deletes present for shards {} - retrying", index, remove.toString());
                    Thread.sleep(sleepTime);
                    sleepTime = Math.min(10000L, sleepTime * 2L);
                    this.logger.debug("{} schedule pending delete retry after {} ms", index, sleepTime);
                } while (System.nanoTime() - startTimeNS < timeout.nanos());
            }
            finally {
                IOUtils.close(shardLocks);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int numPendingDeletes(Index index) {
        Map<Index, List<PendingDelete>> map = this.pendingDeletes;
        synchronized (map) {
            List<PendingDelete> deleteList = this.pendingDeletes.get(index);
            if (deleteList == null) {
                return 0;
            }
            return deleteList.size();
        }
    }

    private static final class PendingDelete
    implements Comparable<PendingDelete> {
        final String index;
        final int shardId;
        final Settings settings;
        final boolean deleteIndex;

        public PendingDelete(ShardId shardId, Settings settings) {
            this.index = shardId.getIndex();
            this.shardId = shardId.getId();
            this.settings = settings;
            this.deleteIndex = false;
        }

        public PendingDelete(Index index, Settings settings) {
            this.index = index.getName();
            this.shardId = -1;
            this.settings = settings;
            this.deleteIndex = true;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("[").append(this.index).append("]");
            if (this.shardId != -1) {
                sb.append("[").append(this.shardId).append("]");
            }
            return sb.toString();
        }

        @Override
        public int compareTo(PendingDelete o) {
            return Integer.compare(this.shardId, o.shardId);
        }
    }

    static class OldShardsStats
    extends IndicesLifecycle.Listener {
        final SearchStats searchStats = new SearchStats();
        final GetStats getStats = new GetStats();
        final IndexingStats indexingStats = new IndexingStats();
        final MergeStats mergeStats = new MergeStats();
        final RefreshStats refreshStats = new RefreshStats();
        final FlushStats flushStats = new FlushStats();
        final RecoveryStats recoveryStats = new RecoveryStats();

        OldShardsStats() {
        }

        @Override
        public synchronized void beforeIndexShardClosed(ShardId shardId, @Nullable IndexShard indexShard, Settings indexSettings) {
            if (indexShard != null) {
                this.getStats.addTotals(indexShard.getStats());
                this.indexingStats.addTotals(indexShard.indexingStats(new String[0]));
                this.searchStats.addTotals(indexShard.searchStats(new String[0]));
                this.mergeStats.addTotals(indexShard.mergeStats());
                this.refreshStats.addTotals(indexShard.refreshStats());
                this.flushStats.addTotals(indexShard.flushStats());
                this.recoveryStats.addTotals(indexShard.recoveryStats());
            }
        }
    }

    static class IndexServiceInjectorPair {
        private final IndexService indexService;
        private final Injector injector;

        public IndexServiceInjectorPair(IndexService indexService, Injector injector) {
            this.indexService = indexService;
            this.injector = injector;
        }

        public IndexService getIndexService() {
            return this.indexService;
        }

        public Injector getInjector() {
            return this.injector;
        }
    }
}

