/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.node.internal;

import com.google.common.base.Charsets;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.common.Booleans;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.cli.Terminal;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.SettingsException;
import org.elasticsearch.env.Environment;

public class InternalSettingsPreparer {
    private static final String[] ALLOWED_SUFFIXES = new String[]{".yml", ".yaml", ".json", ".properties"};
    static final String[] PROPERTY_PREFIXES = new String[]{"es.", "elasticsearch."};
    static final String[] PROPERTY_DEFAULTS_PREFIXES = new String[]{"es.default.", "elasticsearch.default."};
    public static final String SECRET_PROMPT_VALUE = "${prompt.secret}";
    public static final String TEXT_PROMPT_VALUE = "${prompt.text}";
    public static final String IGNORE_SYSTEM_PROPERTIES_SETTING = "config.ignore_system_properties";

    public static Settings prepareSettings(Settings input) {
        Settings.Builder output = Settings.settingsBuilder();
        InternalSettingsPreparer.initializeSettings(output, input, true);
        InternalSettingsPreparer.finalizeSettings(output, null, null);
        return output.build();
    }

    public static Environment prepareEnvironment(Settings input, Terminal terminal) {
        Settings.Builder output = Settings.settingsBuilder();
        InternalSettingsPreparer.initializeSettings(output, input, true);
        Environment environment = new Environment(output.build());
        boolean settingsFileFound = false;
        HashSet<String> foundSuffixes = new HashSet<String>();
        for (String allowedSuffix : ALLOWED_SUFFIXES) {
            Path path = environment.configFile().resolve("elasticsearch" + allowedSuffix);
            if (!Files.exists(path, new LinkOption[0])) continue;
            if (!settingsFileFound) {
                output.loadFromPath(path);
            }
            settingsFileFound = true;
            foundSuffixes.add(allowedSuffix);
        }
        if (foundSuffixes.size() > 1) {
            throw new SettingsException("multiple settings files found with suffixes: " + Strings.collectionToDelimitedString(foundSuffixes, ","));
        }
        InternalSettingsPreparer.initializeSettings(output, input, false);
        InternalSettingsPreparer.finalizeSettings(output, terminal, environment.configFile());
        environment = new Environment(output.build());
        output.put("path.logs", Strings.cleanPath(environment.logsFile().toAbsolutePath().toString()));
        return new Environment(output.build());
    }

    private static boolean useSystemProperties(Settings input) {
        return input.getAsBoolean(IGNORE_SYSTEM_PROPERTIES_SETTING, (Boolean)false) == false;
    }

    private static void initializeSettings(Settings.Builder output, Settings input, boolean loadDefaults) {
        output.put(input);
        if (InternalSettingsPreparer.useSystemProperties(input)) {
            if (loadDefaults) {
                for (String prefix : PROPERTY_DEFAULTS_PREFIXES) {
                    output.putProperties(prefix, System.getProperties());
                }
            }
            for (String prefix : PROPERTY_PREFIXES) {
                output.putProperties(prefix, System.getProperties(), PROPERTY_DEFAULTS_PREFIXES);
            }
        }
        output.replacePropertyPlaceholders();
    }

    private static void finalizeSettings(Settings.Builder output, Terminal terminal, Path configDir) {
        String v;
        String name;
        ArrayList<String> forcedSettings = new ArrayList<String>();
        for (String setting : output.internalMap().keySet()) {
            if (!setting.startsWith("force.")) continue;
            forcedSettings.add(setting);
        }
        for (String forcedSetting : forcedSettings) {
            String value = output.remove(forcedSetting);
            output.put(forcedSetting.substring("force.".length()), value);
        }
        output.replacePropertyPlaceholders();
        if (output.get("name") == null && (name = System.getProperty("name")) != null) {
            output.put("name", name);
        }
        if (output.get("cluster.name") == null) {
            output.put("cluster.name", ClusterName.DEFAULT.value());
        }
        if ((v = output.get("settings_require_units")) != null) {
            Settings.setSettingsRequireUnits(Booleans.parseBoolean(v, true));
        }
        InternalSettingsPreparer.replacePromptPlaceholders(output, terminal);
        if (output.get("name") == null) {
            String name2 = output.get("node.name");
            if (name2 == null || name2.isEmpty()) {
                name2 = InternalSettingsPreparer.randomNodeName(configDir);
            }
            output.put("name", name2);
        }
    }

    private static String randomNodeName(Path configDir) {
        InputStream input;
        if (configDir != null && Files.exists(configDir.resolve("names.txt"), new LinkOption[0])) {
            Path namesPath = configDir.resolve("names.txt");
            try {
                input = Files.newInputStream(namesPath, new OpenOption[0]);
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to load custom names.txt from " + namesPath, e);
            }
        } else {
            input = InternalSettingsPreparer.class.getResourceAsStream("/config/names.txt");
        }
        try {
            ArrayList<String> names = new ArrayList<String>();
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(input, Charsets.UTF_8));){
                String name = reader.readLine();
                while (name != null) {
                    names.add(name);
                    name = reader.readLine();
                }
            }
            int index = ThreadLocalRandom.current().nextInt(names.size());
            return (String)names.get(index);
        }
        catch (IOException e) {
            throw new RuntimeException("Could not read node names list", e);
        }
    }

    private static void replacePromptPlaceholders(Settings.Builder settings, Terminal terminal) {
        ArrayList<String> secretToPrompt = new ArrayList<String>();
        ArrayList<String> textToPrompt = new ArrayList<String>();
        for (Map.Entry<String, String> entry : settings.internalMap().entrySet()) {
            switch (entry.getValue()) {
                case "${prompt.secret}": {
                    secretToPrompt.add(entry.getKey());
                    break;
                }
                case "${prompt.text}": {
                    textToPrompt.add(entry.getKey());
                }
            }
        }
        for (String setting : secretToPrompt) {
            String secretValue = InternalSettingsPreparer.promptForValue(setting, terminal, true);
            if (Strings.hasLength(secretValue)) {
                settings.put(setting, secretValue);
                continue;
            }
            settings.remove(setting);
        }
        for (String setting : textToPrompt) {
            String textValue = InternalSettingsPreparer.promptForValue(setting, terminal, false);
            if (Strings.hasLength(textValue)) {
                settings.put(setting, textValue);
                continue;
            }
            settings.remove(setting);
        }
    }

    private static String promptForValue(String key, Terminal terminal, boolean secret) {
        if (terminal == null) {
            throw new UnsupportedOperationException("found property [" + key + "] with value [" + (secret ? SECRET_PROMPT_VALUE : TEXT_PROMPT_VALUE) + "]. prompting for property values is only supported when running elasticsearch in the foreground");
        }
        if (secret) {
            return new String(terminal.readSecret("Enter value for [%s]: ", key));
        }
        return terminal.readText("Enter value for [%s]: ", key);
    }
}

