/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.plugins;

import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Locale;
import org.apache.commons.cli.CommandLine;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.SuppressForbidden;
import org.elasticsearch.common.cli.CliTool;
import org.elasticsearch.common.cli.CliToolConfig;
import org.elasticsearch.common.cli.Terminal;
import org.elasticsearch.common.logging.log4j.LogConfigurator;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.env.Environment;
import org.elasticsearch.node.internal.InternalSettingsPreparer;
import org.elasticsearch.plugins.PluginManager;

public class PluginManagerCliParser
extends CliTool {
    public static final TimeValue DEFAULT_TIMEOUT = TimeValue.timeValueMillis(0L);
    private static final CliToolConfig CONFIG = CliToolConfig.config("plugin", PluginManagerCliParser.class).cmds(ListPlugins.access$000(), Install.access$100(), Remove.access$200()).build();

    public static void main(String[] args) {
        String loggerLevel = System.getProperty("es.logger.level", "INFO");
        Environment env = InternalSettingsPreparer.prepareEnvironment(Settings.builder().put("appender.terminal.type", "terminal").put("rootLogger", "${es.logger.level}, terminal").put("es.logger.level", loggerLevel).build(), Terminal.DEFAULT);
        LogConfigurator.configure(env.settings(), false);
        int status = new PluginManagerCliParser().execute(args).status();
        PluginManagerCliParser.exit(status);
    }

    @SuppressForbidden(reason="Allowed to exit explicitly from #main()")
    private static void exit(int status) {
        System.exit(status);
    }

    public PluginManagerCliParser() {
        super(CONFIG);
    }

    public PluginManagerCliParser(Terminal terminal) {
        super(CONFIG, terminal);
    }

    @Override
    protected CliTool.Command parse(String cmdName, CommandLine cli) throws Exception {
        switch (cmdName.toLowerCase(Locale.ROOT)) {
            case "install": {
                return Install.parse(this.terminal, cli);
            }
            case "list": {
                return ListPlugins.parse(this.terminal, cli);
            }
            case "remove": {
                return Remove.parse(this.terminal, cli);
            }
        }
        assert (false) : "can't get here as cmd name is validated before this method is called";
        return PluginManagerCliParser.exitCmd(CliTool.ExitStatus.USAGE);
    }

    static class Install
    extends CliTool.Command {
        private static final String NAME = "install";
        private static final CliToolConfig.Cmd CMD = CliToolConfig.Builder.cmd("install", Install.class).options(CliToolConfig.Builder.option("t", "timeout").required(false).hasArg(false)).options(CliToolConfig.Builder.option("b", "batch").required(false)).build();
        final String name;
        private PluginManager.OutputMode outputMode;
        final URL url;
        final TimeValue timeout;
        final boolean batch;

        static CliTool.Command parse(Terminal terminal, CommandLine cli) {
            boolean batch;
            String[] args = cli.getArgs();
            if (args == null || args.length == 0) {
                return PluginManagerCliParser.exitCmd(CliTool.ExitStatus.USAGE, terminal, "plugin name or url is missing (type -h for help)", new Object[0]);
            }
            String name = args[0];
            URL optionalPluginUrl = null;
            try {
                optionalPluginUrl = new URL(name);
                name = null;
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
            TimeValue timeout = TimeValue.parseTimeValue(cli.getOptionValue("t"), DEFAULT_TIMEOUT, "cli");
            PluginManager.OutputMode outputMode = PluginManager.OutputMode.DEFAULT;
            if (cli.hasOption("s")) {
                outputMode = PluginManager.OutputMode.SILENT;
            }
            if (cli.hasOption("v")) {
                outputMode = PluginManager.OutputMode.VERBOSE;
            }
            boolean bl = batch = System.console() == null;
            if (cli.hasOption("b")) {
                batch = true;
            }
            return new Install(terminal, name, outputMode, optionalPluginUrl, timeout, batch);
        }

        Install(Terminal terminal, String name, PluginManager.OutputMode outputMode, URL url, TimeValue timeout, boolean batch) {
            super(terminal);
            this.name = name;
            this.outputMode = outputMode;
            this.url = url;
            this.timeout = timeout;
            this.batch = batch;
        }

        @Override
        public CliTool.ExitStatus execute(Settings settings, Environment env) throws Exception {
            PluginManager pluginManager = new PluginManager(env, this.url, this.outputMode, this.timeout);
            if (this.name != null) {
                this.terminal.println("-> Installing " + Strings.coalesceToEmpty(this.name) + "...", new Object[0]);
            } else {
                this.terminal.println("-> Installing from " + URLDecoder.decode(this.url.toString(), "UTF-8") + "...", new Object[0]);
            }
            pluginManager.downloadAndExtract(this.name, this.terminal, this.batch);
            return CliTool.ExitStatus.OK;
        }

        static /* synthetic */ CliToolConfig.Cmd access$100() {
            return CMD;
        }
    }

    static class Remove
    extends CliTool.Command {
        private static final String NAME = "remove";
        private static final CliToolConfig.Cmd CMD = CliToolConfig.Builder.cmd("remove", Remove.class).build();
        private PluginManager.OutputMode outputMode;
        final String pluginName;

        public static CliTool.Command parse(Terminal terminal, CommandLine cli) {
            String[] args = cli.getArgs();
            if (args.length == 0) {
                return PluginManagerCliParser.exitCmd(CliTool.ExitStatus.USAGE, terminal, "plugin name is missing (type -h for help)", new Object[0]);
            }
            PluginManager.OutputMode outputMode = PluginManager.OutputMode.DEFAULT;
            if (cli.hasOption("s")) {
                outputMode = PluginManager.OutputMode.SILENT;
            }
            if (cli.hasOption("v")) {
                outputMode = PluginManager.OutputMode.VERBOSE;
            }
            return new Remove(terminal, outputMode, args[0]);
        }

        Remove(Terminal terminal, PluginManager.OutputMode outputMode, String pluginToRemove) {
            super(terminal);
            this.outputMode = outputMode;
            this.pluginName = pluginToRemove;
        }

        @Override
        public CliTool.ExitStatus execute(Settings settings, Environment env) throws Exception {
            PluginManager pluginManager = new PluginManager(env, null, this.outputMode, DEFAULT_TIMEOUT);
            this.terminal.println("-> Removing " + Strings.coalesceToEmpty(this.pluginName) + "...", new Object[0]);
            pluginManager.removePlugin(this.pluginName, this.terminal);
            return CliTool.ExitStatus.OK;
        }

        static /* synthetic */ CliToolConfig.Cmd access$200() {
            return CMD;
        }
    }

    static class ListPlugins
    extends CliTool.Command {
        private static final String NAME = "list";
        private static final CliToolConfig.Cmd CMD = CliToolConfig.Builder.cmd("list", ListPlugins.class).build();
        private final PluginManager.OutputMode outputMode;

        public static CliTool.Command parse(Terminal terminal, CommandLine cli) {
            PluginManager.OutputMode outputMode = PluginManager.OutputMode.DEFAULT;
            if (cli.hasOption("s")) {
                outputMode = PluginManager.OutputMode.SILENT;
            }
            if (cli.hasOption("v")) {
                outputMode = PluginManager.OutputMode.VERBOSE;
            }
            return new ListPlugins(terminal, outputMode);
        }

        ListPlugins(Terminal terminal, PluginManager.OutputMode outputMode) {
            super(terminal);
            this.outputMode = outputMode;
        }

        @Override
        public CliTool.ExitStatus execute(Settings settings, Environment env) throws Exception {
            PluginManager pluginManager = new PluginManager(env, null, this.outputMode, DEFAULT_TIMEOUT);
            pluginManager.listInstalledPlugins(this.terminal);
            return CliTool.ExitStatus.OK;
        }

        static /* synthetic */ CliToolConfig.Cmd access$000() {
            return CMD;
        }
    }
}

