/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.fetch.matchedqueries;

import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.ReaderUtil;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.Bits;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.search.SearchParseElement;
import org.elasticsearch.search.fetch.FetchSubPhase;
import org.elasticsearch.search.internal.InternalSearchHit;
import org.elasticsearch.search.internal.SearchContext;

public class MatchedQueriesFetchSubPhase
implements FetchSubPhase {
    @Override
    public Map<String, ? extends SearchParseElement> parseElements() {
        return ImmutableMap.of();
    }

    @Override
    public boolean hitsExecutionNeeded(SearchContext context) {
        return true;
    }

    @Override
    public void hitsExecute(SearchContext context, InternalSearchHit[] hits) {
        if (hits.length == 0) {
            return;
        }
        hits = (InternalSearchHit[])hits.clone();
        Arrays.sort(hits, new Comparator<InternalSearchHit>(){

            @Override
            public int compare(InternalSearchHit a, InternalSearchHit b) {
                return Integer.compare(a.docId(), b.docId());
            }
        });
        List[] matchedQueries = new List[hits.length];
        for (int i = 0; i < matchedQueries.length; ++i) {
            matchedQueries[i] = new ArrayList();
        }
        HashMap<String, Query> namedQueries = new HashMap<String, Query>((Map<String, Query>)context.parsedQuery().namedFilters());
        if (context.parsedPostFilter() != null) {
            namedQueries.putAll((Map<String, Query>)context.parsedPostFilter().namedFilters());
        }
        try {
            for (Map.Entry entry : namedQueries.entrySet()) {
                String name = (String)entry.getKey();
                Query query = (Query)entry.getValue();
                int readerIndex = -1;
                int docBase = -1;
                Weight weight = context.searcher().createNormalizedWeight(query, false);
                Bits matchingDocs = null;
                for (int i = 0; i < hits.length; ++i) {
                    InternalSearchHit hit = hits[i];
                    int hitReaderIndex = ReaderUtil.subIndex(hit.docId(), context.searcher().getIndexReader().leaves());
                    if (readerIndex != hitReaderIndex) {
                        readerIndex = hitReaderIndex;
                        LeafReaderContext ctx = context.searcher().getIndexReader().leaves().get(readerIndex);
                        docBase = ctx.docBase;
                        Scorer scorer = weight.scorer(ctx);
                        matchingDocs = Lucene.asSequentialAccessBits(ctx.reader().maxDoc(), scorer);
                    }
                    if (!matchingDocs.get(hit.docId() - docBase)) continue;
                    matchedQueries[i].add(name);
                }
            }
            for (int i = 0; i < hits.length; ++i) {
                hits[i].matchedQueries(matchedQueries[i].toArray(new String[0]));
            }
        }
        catch (IOException e) {
            throw ExceptionsHelper.convertToElastic(e);
        }
        finally {
            SearchContext.current().clearReleasables(SearchContext.Lifetime.COLLECTION);
        }
    }

    @Override
    public boolean hitExecutionNeeded(SearchContext context) {
        return false;
    }

    @Override
    public void hitExecute(SearchContext context, FetchSubPhase.HitContext hitContext) {
    }
}

