/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.logging.task;

import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.sonatype.nexus.logging.task.TaskLoggerHelper;
import org.sonatype.nexus.logging.task.TaskLoggingMarkers;

public class ProgressLogIntervalHelper {
    private final Stopwatch elapsed;
    private final Stopwatch progress;
    private final Logger logger;
    private final int internal;

    public ProgressLogIntervalHelper(Logger logger, int intervalInSeconds) {
        this.logger = (Logger)Preconditions.checkNotNull((Object)logger);
        this.internal = intervalInSeconds;
        this.elapsed = Stopwatch.createStarted();
        this.progress = Stopwatch.createStarted();
    }

    public String getElapsed() {
        return this.elapsed.toString();
    }

    public void info(String message, Object ... args) {
        if (this.hasIntervalElapsed()) {
            this.logger.info(TaskLoggingMarkers.PROGRESS, message, args);
        } else {
            TaskLoggerHelper.progress(this.logger, message, args);
        }
    }

    public void flush() {
        TaskLoggerHelper.flush();
    }

    private boolean hasIntervalElapsed() {
        boolean logProgress;
        boolean bl = logProgress = this.progress.elapsed(TimeUnit.SECONDS) >= (long)this.internal;
        if (logProgress) {
            this.progress.reset().start();
        }
        return logProgress;
    }
}

