/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.logging.task;

import com.google.common.base.Preconditions;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.MDC;
import org.sonatype.nexus.logging.task.ProgressTaskLogger;
import org.sonatype.nexus.logging.task.TaskLogHome;
import org.sonatype.nexus.logging.task.TaskLogInfo;
import org.sonatype.nexus.logging.task.TaskLoggingMarkers;

public class SeparateTaskLogTaskLogger
extends ProgressTaskLogger {
    private final TaskLogInfo taskLogInfo;
    private final String taskLogIdentifier;

    SeparateTaskLogTaskLogger(Logger log, TaskLogInfo taskLogInfo) {
        super(log);
        this.taskLogInfo = (TaskLogInfo)Preconditions.checkNotNull((Object)taskLogInfo);
        this.taskLogIdentifier = String.format("%s-%s", taskLogInfo.getTypeId(), LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMddHHmmssSSS")));
        MDC.put((String)"taskIdAndDate", (String)this.taskLogIdentifier);
    }

    private void logTaskInfo() {
        this.log.info(TaskLoggingMarkers.TASK_LOG_ONLY, "Task information:");
        this.log.info(TaskLoggingMarkers.TASK_LOG_ONLY, " ID: {}", (Object)this.taskLogInfo.getId());
        this.log.info(TaskLoggingMarkers.TASK_LOG_ONLY, " Type: {}", (Object)this.taskLogInfo.getTypeId());
        this.log.info(TaskLoggingMarkers.TASK_LOG_ONLY, " Name: {}", (Object)this.taskLogInfo.getName());
        this.log.info(TaskLoggingMarkers.TASK_LOG_ONLY, " Description: {}", (Object)this.taskLogInfo.getMessage());
        this.log.debug(TaskLoggingMarkers.TASK_LOG_ONLY, "Task configuration: {}", (Object)this.taskLogInfo.toString());
        String taskLogsHome = TaskLogHome.getTaskLogHome();
        if (taskLogsHome != null) {
            String filename = String.format("%s/%s.log", taskLogsHome, this.taskLogIdentifier);
            this.log.info(TaskLoggingMarkers.NEXUS_LOG_ONLY, "Task log: " + filename);
        }
    }

    @Override
    public final void start() {
        super.start();
        this.logTaskInfo();
    }

    @Override
    public final void finish() {
        super.finish();
        this.log.info(TaskLoggingMarkers.TASK_LOG_ONLY, "Task complete");
        MDC.remove((String)"taskIdAndDate");
        MDC.remove((String)"TASK_LOG_ONLY_MDC");
        MDC.remove((String)"TASK_LOG_WITH_PROGRESS_MDC");
    }

    @Override
    public void flush() {
        if (this.lastProgressEvent != null) {
            Logger logger = Optional.ofNullable(this.lastProgressEvent.getLogger()).orElse(this.log);
            logger.info(TaskLoggingMarkers.PROGRESS, this.lastProgressEvent.getMessage(), this.lastProgressEvent.getArgumentArray());
        }
        super.flush();
    }
}

