/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.logging.task;

import org.slf4j.Logger;
import org.sonatype.nexus.logging.task.TaskLogger;
import org.sonatype.nexus.logging.task.TaskLoggingEvent;

public class TaskLoggerHelper {
    private static final ThreadLocal<TaskLogger> context = new ThreadLocal();

    private TaskLoggerHelper() {
        throw new IllegalAccessError("Utility class");
    }

    public static void start(TaskLogger taskLogger) {
        taskLogger.start();
        context.set(taskLogger);
    }

    public static TaskLogger get() {
        return context.get();
    }

    public static void finish() {
        TaskLogger taskLogger = TaskLoggerHelper.get();
        if (taskLogger != null) {
            taskLogger.finish();
        }
        context.remove();
    }

    public static void progress(TaskLoggingEvent event) {
        TaskLogger taskLogger = TaskLoggerHelper.get();
        if (taskLogger != null) {
            taskLogger.progress(event);
        }
    }

    public static void progress(Logger logger, String message, Object ... args) {
        TaskLoggerHelper.progress(new TaskLoggingEvent(logger, message, args));
    }

    public static void flush() {
        TaskLogger taskLogger = TaskLoggerHelper.get();
        if (taskLogger != null) {
            taskLogger.flush();
        }
    }
}

