/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.orient;

import com.google.common.base.Preconditions;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import org.sonatype.goodies.lifecycle.LifecycleSupport;
import org.sonatype.nexus.orient.DatabaseExternalizer;
import org.sonatype.nexus.orient.DatabaseInstance;
import org.sonatype.nexus.orient.DatabaseManager;
import org.sonatype.nexus.orient.DatabasePool;

public class DatabaseInstanceImpl
extends LifecycleSupport
implements DatabaseInstance {
    private final DatabaseManager databaseManager;
    private final String name;
    private final DatabasePool pool;

    public DatabaseInstanceImpl(DatabaseManager databaseManager, String name) {
        this.databaseManager = (DatabaseManager)Preconditions.checkNotNull((Object)databaseManager);
        this.name = (String)Preconditions.checkNotNull((Object)name);
        this.pool = databaseManager.pool(name);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public boolean isStarted() {
        return super.isStarted();
    }

    protected void doStart() throws Exception {
        this.databaseManager.connect(this.name, true).close();
    }

    @Override
    public ODatabaseDocumentTx connect() {
        this.ensureStarted();
        return this.databaseManager.connect(this.name, false);
    }

    @Override
    public ODatabaseDocumentTx acquire() {
        this.ensureStarted();
        return this.pool.acquire();
    }

    @Override
    public DatabaseExternalizer externalizer() {
        this.ensureStarted();
        return this.databaseManager.externalizer(this.name);
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "{" + "name='" + this.name + '\'' + '}';
    }

    @Override
    public void setFrozen(boolean frozen) {
        this.ensureStarted();
        Throwable throwable = null;
        Object var3_4 = null;
        try (ODatabaseDocumentTx db = this.connect();){
            if (frozen) {
                db.freeze(true);
            } else {
                db.release();
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public boolean isFrozen() {
        this.ensureStarted();
        Throwable throwable = null;
        Object var2_3 = null;
        try (ODatabaseDocumentTx db = this.connect();){
            return db.isFrozen();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

