/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.orient;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.Maps;
import com.orientechnologies.orient.core.db.OPartitionedDatabasePool;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.storage.OStorage;
import java.util.Iterator;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.goodies.lifecycle.Lifecycle;
import org.sonatype.goodies.lifecycle.LifecycleSupport;
import org.sonatype.goodies.lifecycle.Lifecycles;
import org.sonatype.nexus.orient.DatabaseExternalizerImpl;
import org.sonatype.nexus.orient.DatabaseInstance;
import org.sonatype.nexus.orient.DatabaseInstanceImpl;
import org.sonatype.nexus.orient.DatabaseManager;
import org.sonatype.nexus.orient.DatabasePool;
import org.sonatype.nexus.orient.DatabasePoolImpl;
import org.sonatype.nexus.orient.DatabasePoolSupport;
import org.sonatype.nexus.orient.DatabasePoolWithOverflowImpl;
import org.sonatype.nexus.orient.ExplainODatabaseDocumentTx;

public abstract class DatabaseManagerSupport
extends LifecycleSupport
implements DatabaseManager {
    private static final int DEFAULT_MAX_CONNECTIONS_PER_CORE = 16;
    private static final int DEFAULT_MAX_CONNECTIONS = -1;
    private static final String MAX_CONNECTIONS_PER_CORE_PROPERTY = "nexus.orient.maxConnectionsPerCore";
    private static final String MAX_CONNECTIONS_PROPERTY = "nexus.orient.maxConnections";
    private static final String MAX_CONNECTIONS_PER_CORE_PLACEHOLDER = "${nexus.orient.maxConnectionsPerCore:-16}";
    private static final String MAX_CONNECTIONS_PLACEHOLDER = "${nexus.orient.maxConnections:--1}";
    public static final String SYSTEM_USER = "admin";
    public static final String SYSTEM_PASSWORD = "admin";
    private static final String EXPLAIN_PREFIX = "org.sonatype.nexus.orient.explain.";
    private final Map<String, DatabasePoolSupport> pools = Maps.newHashMap();
    private final Map<String, DatabaseInstanceImpl> instances = Maps.newConcurrentMap();
    private int maxConnectionsPerCore = 16;
    private int maxConnections = -1;

    @Inject
    public void setMaxConnectionsPerCore(@Named(value="${nexus.orient.maxConnectionsPerCore:-16}") int maxConnectionsPerCore) {
        this.maxConnectionsPerCore = maxConnectionsPerCore;
    }

    @Inject
    public void setMaxConnections(@Named(value="${nexus.orient.maxConnections:--1}") int maxConnections) {
        this.maxConnections = maxConnections;
    }

    protected void doStart() throws Exception {
        Preconditions.checkState((boolean)this.pools.isEmpty());
        Preconditions.checkState((boolean)this.instances.isEmpty());
    }

    protected void doStop() throws Exception {
        this.stopAllPools();
        this.stopAllInstances();
    }

    private void stopAllInstances() {
        if (this.instances.isEmpty()) {
            return;
        }
        this.log.info("Stopping {} instances", (Object)this.instances.size());
        Iterator<DatabaseInstanceImpl> iter = this.instances.values().iterator();
        while (iter.hasNext()) {
            DatabaseInstanceImpl instance = iter.next();
            if (instance.isStarted()) {
                this.log.info("Stopping instance: {}", (Object)instance.getName());
                try {
                    instance.stop();
                }
                catch (Exception e) {
                    this.log.warn("Failed to stop instance: {}", (Object)instance.getName(), (Object)e);
                }
            } else {
                this.log.info("Instance already stopped: {}", (Object)instance.getName());
            }
            iter.remove();
        }
    }

    private void stopAllPools() {
        if (this.pools.isEmpty()) {
            return;
        }
        this.log.info("Stopping {} pools", (Object)this.pools.size());
        Iterator<DatabasePoolSupport> iter = this.pools.values().iterator();
        while (iter.hasNext()) {
            DatabasePoolSupport pool = iter.next();
            if (pool.isStarted()) {
                this.log.info("Stopping pool: {}", (Object)pool.getName());
                try {
                    pool.stop();
                }
                catch (Exception e) {
                    this.log.warn("Failed to stop pool: {}", (Object)pool.getName(), (Object)e);
                }
            } else {
                this.log.info("Pool already stopped: {}", (Object)pool.getName());
            }
            iter.remove();
        }
    }

    protected abstract String connectionUri(String var1);

    @Override
    public ODatabaseDocumentTx connect(String name, boolean create) {
        Preconditions.checkNotNull((Object)name);
        this.ensureStarted();
        String uri = this.connectionUri(name);
        ODatabaseDocumentTx db = new ODatabaseDocumentTx(uri);
        if (db.exists()) {
            db.open("admin", "admin");
            this.log.debug("Opened database: {} -> {}", (Object)name, (Object)db);
        } else if (create) {
            db.create();
            this.log.debug("Created database: {} -> {}", (Object)name, (Object)db);
            try {
                this.created(db, name);
            }
            catch (Exception e) {
                Throwables.throwIfUnchecked((Throwable)e);
                throw new RuntimeException(e);
            }
        } else {
            this.log.debug("Database does not exist: {}", (Object)name);
        }
        return db;
    }

    protected void created(ODatabaseDocumentTx db, String name) throws Exception {
    }

    @Override
    public DatabaseExternalizerImpl externalizer(String name) {
        Preconditions.checkNotNull((Object)name);
        this.ensureStarted();
        return new DatabaseExternalizerImpl(this, name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DatabasePool pool(String name) {
        Preconditions.checkNotNull((Object)name);
        this.ensureStarted();
        Map<String, DatabasePoolSupport> map = this.pools;
        synchronized (map) {
            DatabasePoolSupport pool = this.pools.get(name);
            if (pool == null) {
                pool = this.createPool(name);
                this.log.debug("Created database pool: {}", (Object)pool);
                this.pools.put(name, pool);
            }
            return pool;
        }
    }

    @Override
    public DatabasePool newPool(String name) {
        Preconditions.checkNotNull((Object)name);
        this.ensureStarted();
        return this.createPool(name);
    }

    private DatabasePoolSupport createPool(String name) {
        DatabasePoolSupport pool;
        String uri = this.connectionUri(name);
        OPartitionedDatabasePool underlying = new OPartitionedDatabasePool(uri, "admin", "admin", this.maxConnectionsPerCore, this.maxConnections);
        if (this.maxConnections > 0) {
            this.log.info("Configuring OrientDB pool {} with overall limit of {}", (Object)name, (Object)this.maxConnections);
            pool = new DatabasePoolImpl(underlying, name);
        } else if (this.maxConnectionsPerCore > 0) {
            OPartitionedDatabasePool overflow = new OPartitionedDatabasePool(uri, "admin", "admin", -1, this.maxConnectionsPerCore);
            this.log.info("Configuring OrientDB pool {} with per-core limit of {}", (Object)name, (Object)this.maxConnectionsPerCore);
            pool = new DatabasePoolWithOverflowImpl(underlying, overflow, name);
        } else {
            throw new IllegalArgumentException("Either nexus.orient.maxConnectionsPerCore or nexus.orient.maxConnections must be positive");
        }
        Lifecycles.start((Lifecycle)pool);
        return pool;
    }

    @Override
    public DatabaseInstance instance(String name) {
        Preconditions.checkNotNull((Object)name);
        this.ensureStarted();
        return this.instances.computeIfAbsent(name, this::createInstance);
    }

    private DatabaseInstanceImpl createInstance(final String name) {
        final Logger explainLogger = LoggerFactory.getLogger((String)(EXPLAIN_PREFIX + name));
        DatabaseInstanceImpl instance = explainLogger.isDebugEnabled() ? new DatabaseInstanceImpl(this, name){

            @Override
            public ODatabaseDocumentTx acquire() {
                String uri = DatabaseManagerSupport.this.connectionUri(name);
                ExplainODatabaseDocumentTx db = new ExplainODatabaseDocumentTx(uri, explainLogger);
                db.open("admin", "admin");
                return db;
            }
        } : new DatabaseInstanceImpl(this, name);
        Lifecycles.start((Lifecycle)instance);
        this.log.debug("Created database instance: {}", (Object)instance);
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void replaceStorage(OStorage storage) {
        DatabasePoolSupport pool;
        Map<String, DatabasePoolSupport> map = this.pools;
        synchronized (map) {
            pool = this.pools.get(storage.getName());
        }
        if (pool != null) {
            pool.replaceStorage(storage);
        }
    }
}

