/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.orient;

import com.google.common.base.Preconditions;
import com.orientechnologies.orient.core.db.OPartitionedDatabasePool;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.storage.OStorage;
import org.sonatype.nexus.orient.DatabasePoolSupport;

public class DatabasePoolWithOverflowImpl
extends DatabasePoolSupport {
    private final OPartitionedDatabasePool delegate;
    private final OPartitionedDatabasePool overflow;

    public DatabasePoolWithOverflowImpl(OPartitionedDatabasePool delegate, OPartitionedDatabasePool overflow, String name) {
        super(name);
        this.delegate = (OPartitionedDatabasePool)Preconditions.checkNotNull((Object)delegate);
        this.overflow = (OPartitionedDatabasePool)Preconditions.checkNotNull((Object)overflow);
    }

    protected void doStop() throws Exception {
        try {
            this.delegate.close();
        }
        finally {
            this.overflow.close();
        }
    }

    @Override
    public ODatabaseDocumentTx acquire() {
        this.ensureStarted();
        try {
            return this.delegate.acquire();
        }
        catch (IllegalStateException e) {
            this.log.debug("Unable to acquire connection from main pool, trying overflow", (Throwable)e);
            return this.overflow.acquire();
        }
    }

    @Override
    public int getAvailableCount() {
        return this.delegate.getAvailableConnections() + this.overflow.getAvailableConnections();
    }

    @Override
    public int getPoolSize() {
        return this.delegate.getCreatedInstances() + this.overflow.getCreatedInstances();
    }

    @Override
    public void replaceStorage(OStorage storage) {
        try {
            this.replaceStorage(this.delegate, storage);
        }
        finally {
            this.replaceStorage(this.overflow, storage);
        }
    }
}

