/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.orient;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.orientechnologies.orient.core.collate.OCaseInsensitiveCollate;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.index.OIndexDefinition;
import com.orientechnologies.orient.core.index.OIndexDefinitionFactory;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.impl.ODocument;
import java.util.List;

public class OIndexBuilder {
    private final OClass type;
    private final String name;
    private final List<String> propertyNames = Lists.newArrayList();
    private final List<OType> propertyTypes = Lists.newArrayList();
    private final OClass.INDEX_TYPE indexType;
    private boolean caseInsensitive;
    private boolean ignoreNullValues;

    public OIndexBuilder(OClass type, String name, OClass.INDEX_TYPE indexType) {
        this.type = (OClass)Preconditions.checkNotNull((Object)type);
        this.name = (String)Preconditions.checkNotNull((Object)name);
        this.indexType = (OClass.INDEX_TYPE)Preconditions.checkNotNull((Object)indexType);
    }

    public OIndexBuilder property(String name, OType type) {
        this.propertyNames.add(name);
        this.propertyTypes.add(type);
        return this;
    }

    public OIndexBuilder caseInsensitive() {
        this.caseInsensitive = true;
        return this;
    }

    public OIndexBuilder ignoreNullValues() {
        this.ignoreNullValues = true;
        return this;
    }

    public OIndex build(ODatabaseDocumentTx db) {
        Preconditions.checkState((!this.propertyNames.isEmpty() ? 1 : 0) != 0, (Object)"At least one property is required");
        Preconditions.checkState((this.propertyTypes.size() == this.propertyNames.size() ? 1 : 0) != 0, (Object)"A type must be defined for each property");
        List collates = null;
        if (this.caseInsensitive) {
            collates = Lists.transform(this.propertyNames, n -> new OCaseInsensitiveCollate());
        }
        ODocument metadata = new ODocument();
        if (this.ignoreNullValues) {
            metadata.field("ignoreNullValues", (Object)true);
        }
        OIndexDefinition indexDefinition = OIndexDefinitionFactory.createIndexDefinition((OClass)this.type, this.propertyNames, this.propertyTypes, (List)collates, (String)this.indexType.name(), null);
        return db.getMetadata().getIndexManager().createIndex(this.name, this.indexType.name(), indexDefinition, this.type.getPolymorphicClusterIds(), null, (ODocument)(metadata.fields() > 0 ? metadata : null));
    }
}

