/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.orient;

import java.util.Optional;

public class ReplicationModeOverrides {
    private static final Optional<Boolean> FORCE_WAIT_FOR_RESULTS = ReplicationModeOverrides.parseWaitForResultsFlag(System.getProperty("nexus.replication.waitForResults"));
    private static final ThreadLocal<Boolean> waitForResults = new ThreadLocal();

    private ReplicationModeOverrides() {
    }

    public static Optional<Boolean> shouldWaitForReplicationResults() {
        return Optional.ofNullable(FORCE_WAIT_FOR_RESULTS.orElseGet(waitForResults::get));
    }

    public static void dontWaitForReplicationResults() {
        waitForResults.set(Boolean.FALSE);
    }

    public static void clearReplicationModeOverrides() {
        waitForResults.remove();
    }

    private static Optional<Boolean> parseWaitForResultsFlag(String flag) {
        if ("TRUE".equalsIgnoreCase(flag)) {
            return Optional.of(Boolean.TRUE);
        }
        if ("FALSE".equalsIgnoreCase(flag)) {
            return Optional.of(Boolean.FALSE);
        }
        return Optional.empty();
    }
}

