/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.orient.entity;

import com.google.common.base.Preconditions;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.record.impl.ODocument;
import org.sonatype.nexus.common.entity.Entity;
import org.sonatype.nexus.common.entity.EntityHelper;
import org.sonatype.nexus.common.entity.EntityMetadata;
import org.sonatype.nexus.orient.entity.AttachedEntityMetadata;

public class AttachedEntityHelper {
    private AttachedEntityHelper() {
    }

    public static AttachedEntityMetadata metadata(Entity entity) {
        EntityMetadata metadata = EntityHelper.metadata((Entity)entity);
        Preconditions.checkState((boolean)(metadata instanceof AttachedEntityMetadata), (Object)"Entity not attached");
        return (AttachedEntityMetadata)metadata;
    }

    public static boolean isAttached(Entity entity) {
        return EntityHelper.metadata((Entity)entity) instanceof AttachedEntityMetadata;
    }

    public static ODocument document(Entity entity) {
        Preconditions.checkNotNull((Object)entity);
        return AttachedEntityHelper.metadata(entity).getDocument();
    }

    public static ORID id(Entity entity) {
        return AttachedEntityHelper.document(entity).getIdentity();
    }

    public static int version(Entity entity) {
        return AttachedEntityHelper.document(entity).getVersion();
    }
}

