/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.orient.entity;

import com.google.common.base.Preconditions;
import com.orientechnologies.orient.core.record.ORecordVersionHelper;
import javax.annotation.Nonnull;
import org.sonatype.nexus.common.entity.EntityVersion;
import org.sonatype.nexus.orient.entity.EntityAdapter;

public class AttachedEntityVersion
implements EntityVersion {
    private final EntityAdapter<?> owner;
    private final int version;
    private volatile String encoded;

    public AttachedEntityVersion(EntityAdapter<?> owner, int version) {
        this.owner = (EntityAdapter)((Object)Preconditions.checkNotNull(owner));
        this.version = version;
    }

    public int getVersion() {
        return this.version;
    }

    @Nonnull
    public String getValue() {
        if (this.encoded == null) {
            Preconditions.checkState((!ORecordVersionHelper.isTemporary((int)this.version) ? 1 : 0) != 0, (Object)"attempted use of temporary/uncommitted document version");
            this.encoded = Integer.toString(this.version);
        }
        return this.encoded;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof AttachedEntityVersion) {
            AttachedEntityVersion that = (AttachedEntityVersion)o;
            return this.version == that.version;
        }
        if (o instanceof EntityVersion) {
            EntityVersion that = (EntityVersion)o;
            return this.getValue().equals(that.getValue());
        }
        return false;
    }

    public int hashCode() {
        return this.getValue().hashCode();
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + '{' + this.owner.getSchemaType() + "->" + this.version + '}';
    }
}

