/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.orient.entity;

import com.orientechnologies.orient.core.conflict.ORecordConflictStrategy;
import com.orientechnologies.orient.core.exception.OConcurrentModificationException;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.serialization.serializer.record.ORecordSaveThreadLocal;
import com.orientechnologies.orient.core.storage.ORawBuffer;
import com.orientechnologies.orient.core.storage.OStorage;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.orient.entity.ConflictState;
import org.sonatype.nexus.orient.entity.EntityAdapter;

@Named
@Singleton
public class ConflictHook
extends ComponentSupport
implements ORecordConflictStrategy {
    public static final String NAME = "ConflictHook";
    private static final Pattern CLUSTER_SHARD_PATTERN = Pattern.compile("(.+?)_[0-9]+");
    private final Map<String, EntityAdapter<?>> resolvingAdapters = new ConcurrentHashMap();
    private final Map<String, String> typeNamesByClusterKey = new ConcurrentHashMap<String, String>();
    private final boolean enabled;

    @Inject
    public ConflictHook(@Named(value="${nexus.orient.conflictHook.enabled:-true}") boolean enabled) {
        this.enabled = enabled;
    }

    public String getName() {
        return NAME;
    }

    public void enableConflictResolution(EntityAdapter<?> adapter) {
        this.log.trace("Enable conflict resolution for {}", adapter);
        this.resolvingAdapters.put(adapter.getTypeName(), adapter);
    }

    public void disableConflictResolution(EntityAdapter<?> adapter) {
        this.log.trace("Disable conflict resolution for {}", adapter);
        this.resolvingAdapters.remove(adapter.getTypeName());
    }

    @Nullable
    public byte[] onUpdate(OStorage storage, byte recordType, ORecordId rid, int recordVersion, byte[] changeContent, AtomicInteger dbVersion) {
        Optional<EntityAdapter<?>> adapter = this.findResolvingAdapter(storage, rid.getClusterId());
        if (adapter.isPresent()) {
            ConflictState state;
            byte[] storedContent = ((ORawBuffer)storage.readRecord(rid, null, false, false, null).getResult()).getBuffer();
            ODocument changeRecord = null;
            if (recordType == 100) {
                ODocument storedRecord = new ODocument((ORID)rid).fromStream(storedContent);
                changeRecord = this.getChangeRecord(rid, changeContent);
                state = adapter.get().resolve(storedRecord, changeRecord);
                this.log.trace("{} update of {} with {}", new Object[]{state, storedRecord, changeRecord});
            } else {
                state = Arrays.equals(storedContent, changeContent) ? ConflictState.IGNORE : ConflictState.DENY;
                this.log.trace("{} binary update of {}", (Object)state, (Object)rid);
            }
            switch (state) {
                case IGNORE: {
                    return null;
                }
                case ALLOW: {
                    dbVersion.set(Math.max(dbVersion.get() + 1, recordVersion));
                    return null;
                }
                case MERGE: {
                    dbVersion.set(Math.max(dbVersion.get(), recordVersion) + 1);
                    return Optional.ofNullable(changeRecord).map(ODocument::toStream).orElse(null);
                }
            }
        }
        throw new OConcurrentModificationException((ORID)rid, dbVersion.get(), recordVersion, 1);
    }

    private ODocument getChangeRecord(ORecordId rid, byte[] content) {
        ODocument record = (ODocument)ORecordSaveThreadLocal.getLast();
        if (record == null || !rid.equals((Object)record.getIdentity())) {
            record = new ODocument((ORID)rid).fromStream(content);
        }
        return record;
    }

    private Optional<EntityAdapter<?>> findResolvingAdapter(OStorage storage, int clusterId) {
        if (!this.enabled) {
            return Optional.empty();
        }
        String clusterKey = String.valueOf(storage.getName()) + '#' + clusterId;
        String typeName = this.typeNamesByClusterKey.computeIfAbsent(clusterKey, k -> ConflictHook.findTypeName(storage.getPhysicalClusterNameById(clusterId)));
        return Optional.ofNullable(typeName).map(this.resolvingAdapters::get);
    }

    @Nullable
    private static String findTypeName(@Nullable String clusterName) {
        Matcher clusterShardMatcher;
        if (clusterName != null && (clusterShardMatcher = CLUSTER_SHARD_PATTERN.matcher(clusterName)).matches()) {
            return clusterShardMatcher.group(1);
        }
        return clusterName;
    }
}

