/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.orient.entity;

import com.google.common.collect.Iterables;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.record.impl.ODocument;
import java.util.Objects;
import javax.annotation.Nullable;
import org.sonatype.nexus.common.entity.Entity;
import org.sonatype.nexus.common.entity.EntityId;
import org.sonatype.nexus.orient.entity.EntityAdapter;
import org.sonatype.nexus.orient.entity.action.BrowseEntitiesAction;
import org.sonatype.nexus.orient.entity.action.CountDocumentsAction;
import org.sonatype.nexus.orient.entity.action.ReadEntityByIdAction;

public abstract class IterableEntityAdapter<T extends Entity>
extends EntityAdapter<T> {
    protected final ReadEntityByIdAction<T> read = new ReadEntityByIdAction(this);
    protected final BrowseEntitiesAction<T> browse = new BrowseEntitiesAction(this);
    protected final CountDocumentsAction count = new CountDocumentsAction(this);

    public IterableEntityAdapter(String typeName) {
        super(typeName);
    }

    public Iterable<T> transform(Iterable<ODocument> documents) {
        return Iterables.filter((Iterable)Iterables.transform(documents, this::transformEntity), Objects::nonNull);
    }

    @Nullable
    protected T transformEntity(@Nullable ODocument document) {
        if (document != null) {
            try {
                return this.readEntity(document);
            }
            catch (Exception | LinkageError e) {
                if (this.log.isDebugEnabled()) {
                    this.log.error("Skipping malformed entity: {}", (Object)document, (Object)e);
                } else {
                    this.log.error("Skipping malformed entity: {} cause: {}", (Object)document, (Object)e.toString());
                }
            }
        } else {
            this.log.debug("Skipping null entity");
        }
        return null;
    }

    @Nullable
    public T read(ODatabaseDocumentTx db, EntityId id) {
        return this.read.execute(db, id);
    }

    public Iterable<T> browse(ODatabaseDocumentTx db) {
        return this.browse.execute(db);
    }

    public long count(ODatabaseDocumentTx db) {
        return this.count.execute(db);
    }

    public int countI(ODatabaseDocumentTx db) {
        return this.count.executeI(db);
    }
}

