/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.orient.entity.action;

import com.google.common.base.Preconditions;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.record.impl.ODocument;
import java.util.ArrayList;
import java.util.List;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.orient.entity.EntityAdapter;

public class BrowsePropertyAction<T>
extends ComponentSupport {
    private final EntityAdapter<?> adapter;
    private final String property;

    public BrowsePropertyAction(EntityAdapter<?> adapter, String property) {
        this.adapter = (EntityAdapter)((Object)Preconditions.checkNotNull(adapter));
        this.property = (String)Preconditions.checkNotNull((Object)property);
    }

    public List<T> execute(ODatabaseDocumentTx db) {
        Preconditions.checkNotNull((Object)db);
        ArrayList<Object> result = new ArrayList<Object>();
        for (ODocument doc : this.adapter.browseDocuments(db)) {
            result.add(doc.field(this.property));
        }
        return result;
    }

    public String toString() {
        return String.valueOf(((Object)((Object)this)).getClass().getSimpleName()) + "{" + "property='" + this.property + '\'' + '}';
    }
}

