/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.orient.entity.action;

import com.google.common.base.Preconditions;
import java.util.Set;
import java.util.StringJoiner;

class QueryUtils {
    private QueryUtils() {
    }

    public static String buildPredicate(String ... properties) {
        Preconditions.checkArgument((properties.length > 0 ? 1 : 0) != 0, (Object)"At least one property is required");
        StringBuilder builder = new StringBuilder(128);
        String[] stringArray = properties;
        int n = properties.length;
        int n2 = 0;
        while (n2 < n) {
            String property = stringArray[n2];
            if (builder.length() > 0) {
                builder.append(" AND ");
            }
            builder.append(property).append(" = ?");
            ++n2;
        }
        return builder.toString();
    }

    public static String buildIn(Set<?> values) {
        Preconditions.checkArgument((!values.isEmpty() ? 1 : 0) != 0, (Object)"At least one value is required");
        StringJoiner joiner = new StringJoiner(",");
        for (Object value : values) {
            joiner.add(String.format("'%s'", value.toString()));
        }
        return String.format("[%s]", joiner.toString());
    }
}

