/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.orient.internal;

import com.google.common.base.Preconditions;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.app.ApplicationDirectories;
import org.sonatype.nexus.orient.DatabaseRestorer;
import org.sonatype.nexus.orient.restore.RestoreFile;

@Named
@Singleton
public class DatabaseRestorerImpl
extends ComponentSupport
implements DatabaseRestorer {
    private static final String RESTORE_FROM_LOCATION = "restore-from-backup";
    private final File restoreFromLocation;

    @Inject
    public DatabaseRestorerImpl(ApplicationDirectories applicationDirectories) {
        this.restoreFromLocation = applicationDirectories.getWorkDirectory(RESTORE_FROM_LOCATION);
    }

    @Override
    public RestoreFile getPendingRestore(String databaseName) throws IOException {
        Preconditions.checkNotNull((Object)databaseName);
        List backupFiles = Files.list(this.restoreFromLocation.toPath()).filter(path -> this.isBackupFileForDatabase((Path)path, databaseName)).collect(Collectors.toList());
        if (backupFiles.size() > 1) {
            throw new IllegalStateException("more than 1 backup file found for database " + databaseName + ": " + backupFiles);
        }
        return backupFiles.isEmpty() ? null : RestoreFile.newInstance((Path)backupFiles.get(0));
    }

    @Override
    public boolean maybeRestoreDatabase(ODatabaseDocumentTx db, String databaseName) throws IOException {
        Preconditions.checkNotNull((Object)db);
        Preconditions.checkNotNull((Object)databaseName);
        this.log.debug("checking if database {} should be restored", (Object)databaseName);
        Path path = this.getRestorePath(databaseName);
        if (path != null) {
            this.log.info("restoration of database {} from file {} starting", (Object)databaseName, (Object)path);
            this.doRestore(path.toFile(), db, databaseName);
            return true;
        }
        return false;
    }

    @Override
    public boolean isRestoreFromLocation(File location) throws IOException {
        return Files.isSameFile(this.restoreFromLocation.toPath(), location.toPath());
    }

    protected Path getRestorePath(String databaseName) throws IOException {
        Preconditions.checkNotNull((Object)databaseName);
        List backupFiles = Files.list(this.restoreFromLocation.toPath()).filter(path -> this.isBackupFileForDatabase((Path)path, databaseName)).collect(Collectors.toList());
        if (backupFiles.size() > 1) {
            throw new IllegalStateException("more than 1 backup file found for database " + databaseName + ": " + backupFiles);
        }
        return backupFiles.isEmpty() ? null : (Path)backupFiles.get(0);
    }

    private void doRestore(File file, ODatabaseDocumentTx db, String databaseName) {
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (FileInputStream inputStream = new FileInputStream(file);){
                db.restore((InputStream)inputStream, null, null, iText -> this.log.debug("database restore of {}, received message '{}'", (Object)databaseName, (Object)iText));
                this.log.info("database {} restored", (Object)databaseName);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("database restore of %s from %s failed", databaseName, file), e);
        }
    }

    private boolean isBackupFileForDatabase(Path path, String databaseName) {
        Preconditions.checkNotNull((Object)path);
        Preconditions.checkNotNull((Object)databaseName);
        this.log.trace("testing if {} is a backup file for {}", (Object)path, (Object)databaseName);
        Path pathFile = path.getFileName();
        if (pathFile != null) {
            String filename = pathFile.toString();
            return Files.isRegularFile(path, new LinkOption[0]) && filename.startsWith(String.valueOf(databaseName) + '-') && filename.endsWith(".bak");
        }
        return false;
    }
}

