/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.orient.internal.freeze;

import java.util.List;
import org.sonatype.nexus.orient.freeze.FreezeRequest;
import org.sonatype.nexus.orient.freeze.ReadOnlyState;

class DefaultReadOnlyState
implements ReadOnlyState {
    private final List<FreezeRequest> state;
    private final boolean authorized;

    DefaultReadOnlyState(List<FreezeRequest> state, boolean authorized) {
        this.state = state;
        this.authorized = authorized;
    }

    @Override
    public boolean isFrozen() {
        return !this.state.isEmpty();
    }

    @Override
    public String getSummaryReason() {
        if (!this.authorized || this.state.isEmpty()) {
            return "";
        }
        return this.state.stream().filter(r -> FreezeRequest.InitiatorType.USER_INITIATED.equals((Object)r.getInitiatorType())).findAny().map(u -> String.format("activated by an administrator at %s", u.getTimestamp().toString("yyyy-MM-dd HH:mm:ss ZZ"))).orElse(String.format("activated by %s running system task(s)", this.state.size()));
    }

    @Override
    public boolean isSystemInitiated() {
        return this.state.stream().anyMatch(r -> FreezeRequest.InitiatorType.SYSTEM.equals((Object)r.getInitiatorType()));
    }
}

