/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.orient.internal.freeze;

import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricSet;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import javax.inject.Provider;
import org.joda.time.base.AbstractInstant;
import org.joda.time.base.BaseDateTime;
import org.sonatype.nexus.orient.freeze.DatabaseFreezeService;
import org.sonatype.nexus.orient.freeze.FreezeRequest;

public class ReadOnlyMetricSet
implements MetricSet {
    private final Map<String, Metric> metrics;

    public ReadOnlyMetricSet(Provider<DatabaseFreezeService> databaseFreezeServiceProvider) {
        Preconditions.checkNotNull(databaseFreezeServiceProvider);
        this.metrics = ImmutableMap.of((Object)"enabled", (Object)this.enabled(databaseFreezeServiceProvider), (Object)"pending", (Object)this.pending(databaseFreezeServiceProvider), (Object)"freezeTime", (Object)this.freezeTime(databaseFreezeServiceProvider));
    }

    public Map<String, Metric> getMetrics() {
        return this.metrics;
    }

    private Metric enabled(Provider<DatabaseFreezeService> databaseFreezeServiceProvider) {
        return () -> Optional.ofNullable((DatabaseFreezeService)databaseFreezeServiceProvider.get()).map(DatabaseFreezeService::isFrozen).orElse(false);
    }

    private Metric pending(Provider<DatabaseFreezeService> databaseFreezeServiceProvider) {
        return () -> Optional.ofNullable((DatabaseFreezeService)databaseFreezeServiceProvider.get()).map(databaseFreezeService -> databaseFreezeService.getState().size()).orElse(0);
    }

    private Metric freezeTime(Provider<DatabaseFreezeService> databaseFreezeServiceProvider) {
        return () -> Optional.ofNullable((DatabaseFreezeService)databaseFreezeServiceProvider.get()).map(databaseFreezeService -> {
            Long val = databaseFreezeService.getState().stream().map(FreezeRequest::getTimestamp).min(AbstractInstant::compareTo).map(BaseDateTime::getMillis).orElse(0L);
            return val;
        }).orElse(0L);
    }
}

