/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.orient.internal.rest;

import com.google.common.base.Preconditions;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.orient.freeze.DatabaseFreezeService;
import org.sonatype.nexus.orient.freeze.FreezeRequest;
import org.sonatype.nexus.orient.freeze.ReadOnlyState;
import org.sonatype.nexus.orient.internal.rest.DatabaseFreezeResourceDoc;
import org.sonatype.nexus.rest.Resource;
import org.sonatype.nexus.security.SecurityHelper;

@Named
@Singleton
@Path(value="/v1/read-only")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class DatabaseFreezeResource
extends ComponentSupport
implements Resource,
DatabaseFreezeResourceDoc {
    public static final String RESOURCE_URI = "/v1/read-only";
    private final DatabaseFreezeService freezeService;
    private final SecurityHelper securityHelper;

    @Inject
    public DatabaseFreezeResource(DatabaseFreezeService freezeService, SecurityHelper securityHelper) {
        this.freezeService = (DatabaseFreezeService)Preconditions.checkNotNull((Object)freezeService);
        this.securityHelper = (SecurityHelper)Preconditions.checkNotNull((Object)securityHelper);
    }

    @Override
    @GET
    public ReadOnlyState get() {
        return this.freezeService.getReadOnlyState();
    }

    @Override
    @RequiresAuthentication
    @RequiresPermissions(value={"nexus:*"})
    @POST
    @Path(value="/freeze")
    public void freeze() {
        if (this.freezeService.requestFreeze(FreezeRequest.InitiatorType.USER_INITIATED, this.principalAsString()) == null) {
            throw new WebApplicationException("Attempt to enable read-only failed", 404);
        }
    }

    @Override
    @RequiresAuthentication
    @RequiresPermissions(value={"nexus:*"})
    @POST
    @Path(value="/release")
    public void release() {
        boolean success = this.freezeService.releaseUserInitiatedIfPresent();
        if (!success) {
            throw new WebApplicationException("Attempt to release read-only failed", 404);
        }
    }

    @Override
    @RequiresAuthentication
    @RequiresPermissions(value={"nexus:*"})
    @POST
    @Path(value="/force-release")
    public void forceRelease() {
        if (this.freezeService.releaseAllRequests().isEmpty()) {
            throw new WebApplicationException("Attempt to force release read-only failed", 404);
        }
    }

    private String principalAsString() {
        Object principal = this.securityHelper.subject().getPrincipal();
        if (principal == null) {
            throw new WebApplicationException("Unauthorized", 401);
        }
        return principal.toString();
    }
}

