/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.orient.transaction;

import com.google.common.base.Preconditions;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.tx.OTransaction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.nexus.common.property.SystemPropertiesHelper;
import org.sonatype.nexus.common.sequence.NumberSequence;
import org.sonatype.nexus.common.sequence.RandomExponentialSequence;
import org.sonatype.nexus.transaction.Transaction;
import org.sonatype.nexus.transaction.UnitOfWork;

public class OrientTransaction
implements Transaction {
    private static final Logger log = LoggerFactory.getLogger(OrientTransaction.class);
    private static final int INITIAL_DELAY_MS = SystemPropertiesHelper.getInteger((String)(String.valueOf(OrientTransaction.class.getName()) + ".retrydelay.initial"), (int)10);
    private static final int MAX_RETRIES = 8;
    private final ODatabaseDocumentTx db;
    private int retries = 0;
    private NumberSequence retryDelay;

    OrientTransaction(ODatabaseDocumentTx db) {
        this.db = (ODatabaseDocumentTx)Preconditions.checkNotNull((Object)db);
    }

    public ODatabaseDocumentTx getDb() {
        return this.db;
    }

    public static ODatabaseDocumentTx currentDb() {
        Transaction tx = UnitOfWork.currentTx();
        if (tx instanceof OrientTransaction) {
            return ((OrientTransaction)tx).db;
        }
        try {
            return (ODatabaseDocumentTx)tx.getClass().getMethod("getDb", new Class[0]).invoke((Object)tx, new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Transaction " + tx + " has no public 'getDb' method", e);
        }
    }

    public void begin() {
        this.db.begin();
    }

    public void commit() {
        this.db.commit();
        this.retries = 0;
    }

    public void rollback() {
        this.db.rollback();
    }

    public void close() {
        this.db.close();
    }

    public boolean isActive() {
        OTransaction tx = null;
        if (this.db.isActiveOnCurrentThread()) {
            tx = this.db.getTransaction();
        }
        return tx != null && tx.isActive();
    }

    public boolean allowRetry(Exception cause) {
        if (this.retries < 8) {
            try {
                if (this.retryDelay == null) {
                    this.retryDelay = OrientTransaction.delaySequence();
                }
                long delay = this.retryDelay.next();
                log.trace("Delaying tx retry for {}ms", (Object)delay);
                Thread.sleep(delay);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            ++this.retries;
            log.debug("Retrying operation: {}/{}", (Object)this.retries, (Object)8);
            return true;
        }
        log.warn("Reached max retries: {}/{}", (Object)this.retries, (Object)8);
        return false;
    }

    private static NumberSequence delaySequence() {
        return RandomExponentialSequence.builder().start(INITIAL_DELAY_MS).factor(2.0).maxDeviation(0.5).build();
    }
}

